unit ESetArrayService;


interface
uses SysUtils, Dialogs, Controls, StrUtils, Grids,
     MAINDATA, Reports, ComplexOp, CommonService, ESetGridService;

//    TESetRec   ESet
//  : (01.09.2010)
// 1.    
// 2.    
//
const cESetRecHead = 1;               //   
      cESetRecData = 2;               //   
      cESetRecTail = 3;               //   
type  TptESetRec   = ^TESetRec;
      TESetRec     = record
      case RecId   : integer of
      cESetRecHead : ( // 24 - 
               DataIdn : string[16];  //   = 'ESet Matrix Data'
               DataVer : string[4];   //    = ' V1 '
               MaxRow  : LongInt;     //    ESet
               MaxCol  : LongInt;     //    ESet
               );
      cESetRecData : ( //  52 - 
               ArrRow  : LongInt;     //    ArrDat
               ArrCol  : LongInt;     //    ArrDat
               ArrDat  : T2Complex;   //   
               );
      cESetRecTail : ( //  52 - 
               Comment : string[50];  //   
               );
end; // of type TESetRecord


//     ESet
function InitESetArrays (
           var RqESetCTRL : TESetCTRL;  //    
               RqMaxRow   : LongInt     //     
                        ) : boolean;

//       
function MakeRandomTestESet (var RqESetCTRL : TESetCTRL) : boolean;

//       
procedure CopyESetToWork (var RqESetCTRL : TESetCTRL);

//       *.esm
function LoadESetSRC
             (RqFileName   : string;         //    
          var RqESetCTRL   : TESetCTRL;      //    
               RqVPESet    : T2CmpToStrParm; //    
               RqGridESET  : TStringGrid;    // Grid  
               RqGridRoot  : TStringGrid)    // Grid  
                           : boolean;

//  " "  ESetSRC   *.esm
procedure SaveAsESetSRC
                (RqFileName     : string;      //   
                 var RqESetCTRL : TESetCTRL);  //    ESet

//   ESetSRC  
procedure ReSaveESetSRC (var RqESetCTRL : TESetCTRL);

// ==========================================================================
implementation
// ==========================================================================

var
//    
// Type for User File Control Block
ESetUFCB  : TUFCB;

var
//   TESetRec   ESet
ESetRecBuf : TESetRec;

//---------------------------------------------------------------------------
//     ESet
function InitESetArrays (
           var RqESetCTRL : TESetCTRL;  //    
               RqMaxRow   : LongInt     //     
                        ) : boolean;
var Row, Col : LongInt;  //  
begin
 Result := False;        //  
 try
    with RqESetCTRL do
    begin
       ESetRowCount := RqMaxRow;
       ESetColCount := RqMaxRow + 1;
       TestFlag     := False;
       //    
       SetRunProress('InitESetArrays', 0, 1, RqMaxRow);
       //      RqESetCTRL
       SetLength(ESetSRC,   ESetRowCount);
       SetLength(ESetWRK,   ESetRowCount);
       SetLength(ESetRoots, ESetRowCount);
       SetLength(TestRoots, 0);
       //    RqESetCTRL
       for Row := Low(ESetSRC) to High(ESetSRC) do
       begin
         //     
         ProressOneStep();
         //     
         ZeroToComplex(ESetRoots[Row]);
         //        RqESetCTRL
         SetLength(ESetSRC[Row], ESetColCount);
         SetLength(ESetWRK[Row], ESetColCount);
         for Col := Low(ESetSRC[Row]) to High(ESetSRC[Row]) do
         begin
            //     
            ZeroToComplex(ESetSRC[Row, Col]);
            //     
            ComplexToComplex (ESetSRC[Row, Col], ESetWRK[Row, Col]);
         end; // of for Col
      end; // of for Row
    end; // of with RqESetCTRL
    DebugMsgToReport('    ');
    Result := True;
 except
    ErrorMsgToReport (True,  //    
                      False, //   
                      ' SYSERROR(InitESetArrays):'
                    + '    ');
 end;
 //   
 ProressToMin();
end;

//===========================================================================
//     
//---------------------------------------------------------------------------
// 01.09.2010 (ver 1.00)
//       +/- 
function GetRandomScale() : Extended;
const Scale = 1000;        //  
begin
   Result := 2 * ((Scale/2) - Random(Scale)) / (Scale + 1);
end;

//---------------------------------------------------------------------------
// 01.09.2010 (ver 1.00)
//       
function MakeRandomTestESet (var RqESetCTRL : TESetCTRL) : boolean;
var Row, Col : LongInt;     //  
    RowSum   : T2Complex;   //   
begin
 Result := False;           //  
 try
    with RqESetCTRL do
    begin
      //  
      if (Length(ESetSRC)    = ESetRowCount) and
         (Length(ESetSRC[0]) = ESetColCount)
      then begin
         //    
         SetRunProress('MakeRandomTestESet', 0, 1, ESetRowCount);
         //     
         Randomize;
         //     
         SetLength(TestRoots,  ESetRowCount);
         //     (  )
         for Row := Low(ESetSRC) to High(ESetSRC) do
         begin
           //     
           ProressOneStep();
           //    
           TestRoots[Row].r := TestRootsReMax * GetRandomScale;
           TestRoots[Row].i := TestRootsImMax * GetRandomScale;
           DecartToPolar (TestRoots[Row]);
           for Col := Low(ESetSRC[Row]) to High(ESetSRC[Row]) do
           begin
              //   
              if Col < (ESetColCount - 1)
              then begin
                ESetSRC[Row, Col].r := TestCoeffReMax * GetRandomScale;
                ESetSRC[Row, Col].i := TestCoeffImMax * GetRandomScale;
                DecartToPolar (ESetSRC[Row, Col]);
              end;
           end; // of for Col
         end; // of for Row
         //     ( )
         for Row := Low(ESetSRC) to High(ESetSRC) do
         begin
           //      
           ZeroToComplex(RowSum);
           //    
           for Col := Low(ESetSRC[Row]) to High(ESetSRC[Row]) - 1 do
           begin
              RowSum := SumDC(RowSum, MulDC(ESetSRC[Row,Col], TestRoots[Col]));
           end; // of for Col
           ComplexToComplex (RowSum, ESetSRC[Row, High(ESetSRC[Row])]);
           DecartToPolar (ESetSRC[Row, High(ESetSRC[Row])]);
         end; // of for Row
         //  
         TestFlag := True;   //    
         Result := True;
         InfoMsgToReport (False, //    
                          False, //   
                          '    '
                        + '  ');
      end; // of if
    end; // of with RqESetCTRL
 except
    ErrorMsgToReport (True,  //    
                      False, //   
                      ' SYSERROR(MakeRandomTestESet):'
                    + '     ');
 end;
 //   
 ProressToMin();
end;

//---------------------------------------------------------------------------
// 01.09.2010 (ver 1.00)
//       
procedure CopyESetToWork (var RqESetCTRL : TESetCTRL);
var Row, Col : LongInt;     //  
begin
  with RqESetCTRL do
  begin
    //  
    if (Length(ESetSRC)    = Length(ESetWRK)) and
       (Length(ESetSRC[0]) = Length(ESetWRK[0]))
    then begin
       //    
       SetRunProress('CopyESetToWork', 0, 1, High(ESetSRC));
       for Row := Low(ESetSRC) to High(ESetSRC) do
       begin
         //     
         ProressOneStep();
         for Col := Low(ESetSRC[Row]) to High(ESetSRC[Row])
         do  ComplexToComplex (ESetSRC[Row,Col], ESetWRK[Row,Col]);
       end; // of for Row
    end; // of if
  end; // of with RqESetCTRL
  //   
  ProressToMin();
end;


//===========================================================================
//       
//===========================================================================
//---------------------------------------------------------------------------
// 01.09.2010 (ver 1.00)    
//     LoadESetHeadFromFile
//      ESet
function VerifyESetHead (RqESetRecBuf : TESetRec): boolean;
begin
  Result := False;          //  
  with RqESetRecBuf do
  begin
     if RecId = cESetRecHead
     then begin
         //  Row  Col  
         if (MaxRow >= MinNewESetRow) and
            (MaxRow <= MaxNewESetRow) and
            (MaxCol  = MaxRow + 1)
         then begin
            DebugMsgToReport('    ');
            Result := True;
         end;
     end;
  end; // of with RqESetRecBuf
end; // of function VerifyESetHead

//---------------------------------------------------------------------------
//     LoadESetSrcFromFile
//       ESetSRC
function LoadESetHeadFromFile(
              var RqESetCTRL : TESetCTRL;  //    ESet
              var RqUFCB     : TUFCB       //    
                             ) : boolean;
begin
   Result := False;           //  
   if RqUFCB.FlagOpen and (RqUFCB.OpenMode = fmOpenRead)
   then begin
      //    ESetRecBuf
      FillChar (ESetRecBuf, SizeOf(ESetRecBuf),#0);
      //   
      if ReadOneRec(RqUFCB)
      then begin
         DebugMsgToReport('    ');
         //    
         if VerifyESetHead (ESetRecBuf)
         then begin
             //  
             DebugMsgToReport('    ');
             Result := True;
         end
         else begin
             //       
             ColoseUFCB(RqUFCB);
             ErrorMsgToReport
                  (True,  //    
                   False, //   
                   '       ');
         end;
      end
      else begin
         //      
         ColoseUFCB(RqUFCB);
         ErrorMsgToReport
              (True,  //    
               False, //   
              ' I/O ERROR.    ');
      end;
   end; // of if RqUFCB.FlagOpen
end; // of function LoadESetHeadFromFile

//---------------------------------------------------------------------------
//     LoadESetSrcFromFile
//       ESetSRC
function LoadESetBodyFromFile(
          var RqESetCTRL : TESetCTRL;  //    ESet
          var RqUFCB     : TUFCB       //    
                              ) : boolean;
var wRow, wCol : LongInt;     //  
begin
   Result := False;           //  
   if RqUFCB.FlagOpen and (RqUFCB.OpenMode = fmOpenRead)
   then begin
      with RqESetCTRL
      do begin
         //    
         SetRunProress('LoadESetBodyFromFile', 0, 1, High(ESetSRC));
         for wRow := Low(ESetSRC) to High(ESetSRC)
         do begin
            //     
            ProressOneStep();
            for wCol := Low(ESetSRC[wRow]) to High(ESetSRC[wRow])
            do begin
              //    ESetRecBuf
              FillChar (ESetRecBuf, SizeOf(ESetRecBuf),#0);
              //    
              if ReadOneRec(RqUFCB)
              then begin
                 if (ESetRecBuf.RecId = cESetRecData) and
                    (ESetRecBuf.ArrRow = wRow) and
                    (ESetRecBuf.ArrCol = wCol)
                 then begin
                   //     ESetSRC
                    ComplexToComplex
                                  (ESetRecBuf.ArrDat,
                                   ESetSRC[wRow,wCol]);
                 end
                 else begin
                    //     
                    //    
                    ColoseUFCB(RqUFCB);
                    DebugMsgToReport('    . RecId = '
                                    + IntToStr(ESetRecBuf.RecId)
                                    + ', Row = '
                                    + IntToStr (ESetRecBuf.ArrRow)
                                    + ', Col = '
                                    + IntToStr (ESetRecBuf.ArrCol));
                    //   
                    ProressToMin();
                    Exit;  //   
                 end; //    
              end
              else begin
                 //       
                 ColoseUFCB(RqUFCB);
                 ErrorMsgToReport
                            (True,  //  
                             False, //  
                             ' I/O ERROR.   .'
                             + ' Row = '
                             + IntToStr (wRow)
                             + ', Col = '
                             + IntToStr (wCol));
                 //   
                 ProressToMin();
                 Exit;  //   
              end; // of ReadOneRec(RqUFCB) Data
            end; // of for wCol
         end; // of for wRow
         //  
         DebugMsgToReport('    ');
         Result := True;
      end; //  of with RqESetCTRL
   end; // of if RqUFCB.FlagOpen
   //   
   ProressToMin();
end;  // 0f function LoadESetBodyFromFile

//---------------------------------------------------------------------------
//     LoadESetSrcFromFile
//       ESetSRC
function LoadESetTailFromFile(
          var RqESetCTRL : TESetCTRL;  //    ESet
          var RqUFCB     : TUFCB       //    
                              ) : boolean;
begin
   //  
   Result := False;           //  
   if RqUFCB.FlagOpen and (RqUFCB.OpenMode = fmOpenRead)
   then begin
      //  
      DebugMsgToReport('    ');
      Result := True;
   end; // of if RqUFCB.FlagOpen
end;  // 0f function LoadESetTailFromFile

//---------------------------------------------------------------------------
// 01.09.2010 (ver 1.00)     
//  ESetSRC   
function LoadESetSrcFromFile (
                  RqFileName : string;     //     
              var RqESetCTRL : TESetCTRL;  //    ESet
              var RqUFCB     : TUFCB       //    
                             ) : boolean;
begin
  Result := False;            //  
  //     
  if not RqUFCB.FlagOpen
  then begin
     //    RqUFCB
     FillChar (RqUFCB, SizeOf(RqUFCB),#0);
     OpenUFCB
        (RqFileName,          //   
         fmOpenRead,          //  
         False,               //   
         SizeOf(ESetRecBuf),  //   
         Addr(ESetRecBuf),    //   
         RqUFCB);             //    
   end;
   if RqUFCB.FlagOpen
   then begin
      //       ESetSRC
      if LoadESetHeadFromFile(
                           RqESetCTRL,   //    ESet
                           RqUFCB)       //    
      then begin
          //      
          if InitESetArrays
                   (RqESetCTRL,          //    
                    ESetRecBuf.MaxRow)   //     
          then begin
              //       ESetSRC
              if LoadESetBodyFromFile(
                           RqESetCTRL,  //    ESet
                           RqUFCB)      //    
              then begin
                  //       ESetSRC
                  if LoadESetTailFromFile(
                           RqESetCTRL,  //    ESet
                           RqUFCB)      //    
                  then begin
                      //    
                      //   c   RqUFCB
                      ColoseUFCB(RqUFCB);
                      DebugMsgToReport('    '
                                     + '   ');
                      //    
                      Result := True;
                  end; // of if LoadESetTailFromFile
              end; // of if LoadESetBodyFromFile
          end; // of if InitESetArrays
      end; // of if LoadESetHeadFromFile
   end
   else begin
       ErrorMsgToReport
         (True,  //  
          False, //  
          ' OPEN I/O ERROR.'
         + #13#10
         + '     .');
   end; // of if RqUFCB.FlagOpen
end; // of function LoadESetSrcFromFile

//---------------------------------------------------------------------------
// 01.09.2010 (ver.1.00)
//        *.esm
function LoadESetSRC
             (RqFileName   : string;          //    
          var RqESetCTRL   : TESetCTRL;       //    
               RqVPESet    : T2CmpToStrParm;  //    
               RqGridESET  : TStringGrid;     // Grid  
               RqGridRoot  : TStringGrid)     // Grid  
                           : boolean;
var FullFileName : string;
begin
    Result := False;  //  
    FullFileName := Trim(RqFileName);
    if UpperCase(RightStr(FullFileName,4)) <> '.ESM'
    //    (  )  
    then begin
       FullFileName := FullFileName + '.esm';
    end;
    if FileExists(FullFileName)
    then begin
       with RqESetCTRL
       do begin
          //    ESetSRC
          if LoadESetSrcFromFile
               (FullFileName,  //     
                RqESetCTRL,    //    ESet
                ESetUFCB)      //    
          then begin
              //    
              ESetFFileName := FullFileName;
              ESetSFileName := ExtractFileName(FullFileName);
              //    
              InfoMsgToReport
                   (True,   //    
                    False,  //   
                    '    : '
                    + UpperCase(RqESetCTRL.ESetSFileName));
              //  
              Result := True;
          end
          else begin
              //   
              //     
              ErrorMsgToReport
                  (True,   //    
                   False,  //   
                  '      ');
              //    
              ESetFFileName := '';    // ''    
              ESetSFileName := '';    // ''    
              //    
              ESetComment := '';      //     ESetSRC
              //     
              InitESetArrays
                        (RqESetCTRL,      //   
                         MinNewESetRow);  // .    
          end; // of if LoadESetSrcFromFile
       end; // of with RqESetCTRL

       //    (Grids),     
       if InitAllESetGrids
                (RqESetCTRL,   //    
                 RqGridESET,   // Grid   
                 RqGridRoot)   // Grid    
       then begin
             //   
             ShowESetToGrid
                 (RqESetCTRL.ESetSRC,   //   
                  RqVPESet,             //    
                  RqGridESET);          //  Grid
             //    
             //   Grid 
             IdShowGridESET := cShowESetSRC;
       end;
    end; //of if FileExists(FullFileName)
end; // of function LoadDialogESetSRC


//===========================================================================
//       
//===========================================================================
// 05.09.2010 (ver.1.00)
//     SaveESetHeadToFile
//     ESetSRC
procedure MakeESetHeadFile(RqESetCTRL : TESetCTRL); //   ESet
begin
   //   ESetRecBuf
   FillChar (ESetRecBuf, SizeOf(ESetRecBuf),#0);
   //     
   ESetRecBuf.RecId := cESetRecHead;   //   
   ESetRecBuf.DataIdn := 'ESet Matrix Data';
   ESetRecBuf.DataVer := ' V1 ';
   ESetRecBuf.MaxRow := Length(RqESetCTRL.ESetSRC);
   ESetRecBuf.MaxCol := ESetRecBuf.MaxRow + 1;
end;

//---------------------------------------------------------------------------
// 05.09.2010 (ver.1.00)
//     SaveESetSrcToFile
//       ESetSRC
function SaveESetHeadToFile(
              var RqESetCTRL : TESetCTRL;  //    ESet
              var RqUFCB     : TUFCB       //    
                             ) : boolean;
begin
   Result := False;           //  
   if RqUFCB.FlagOpen and (RqUFCB.OpenMode = fmOpenWrite)
   then begin
      //     
      MakeESetHeadFile(RqESetCTRL);
      //    
      if WriteOneRec(RqUFCB)
      then begin
         //  
         DebugMsgToReport('    ');
         Result := True;
      end
      else begin
         //     
         ColoseUFCB(RqUFCB);
         ErrorMsgToReport
              (True,  //    
               False, //   
              ' I/O ERROR.    ');
      end;
   end; // of if RqUFCB.FlagOpen
end; // of function SaveESetHeadToFile

//---------------------------------------------------------------------------
// 05.09.2010 (ver.1.00)
//     SaveESetSrcToFile
//       ESetSRC
function SaveESetBodyToFile(
                  RqESetCTRL : TESetCTRL;  //    ESet
              var RqUFCB     : TUFCB       //    
                             ) : boolean;
var wRow, wCol : LongInt;                  //  
begin
   Result := False;           //  
   if RqUFCB.FlagOpen and (RqUFCB.OpenMode = fmOpenWrite)
   then begin
      with RqESetCTRL
      do begin
          //    
          SetRunProress('SaveESetBodyToFile', 0, 1, High(ESetSRC));
          for wRow := Low(ESetSRC) to High(ESetSRC)
          do begin
              //     
              ProressOneStep();
              for wCol := Low(ESetSRC[wRow]) to High(ESetSRC[wRow])
              do begin
                 //    ESetSRC   
                 ESetRecBuf.RecId := cESetRecData;   //   
                 ESetRecBuf.ArrRow := wRow;
                 ESetRecBuf.ArrCol := wCol;
                 ComplexToComplex(RqESetCTRL.ESetSRC[wRow,wCol],
                                  ESetRecBuf.ArrDat);
                 if not WriteOneRec(RqUFCB)
                 then begin
                   //      ESetSRC
                   //   c   RqUFCB
                   ColoseUFCB(RqUFCB);
                   ErrorMsgToReport
                            (True,  //  
                             False, //  
                             ' I/O ERROR.   .'
                             + ' Row = '
                             + IntToStr (wRow)
                             + ', Col = '
                             + IntToStr (wCol));
                   //   
                   ProressToMin();
                   Exit;  //   
                 end;
              end; // of for wRow
          end; // of for wCol
      end; // of with RqESetCTRL
      //  
      DebugMsgToReport('    ');
      //   
      ProressToMin();
      Result := True;
   end; // of if RqUFCB.FlagOpen
end; // of function SaveESetBodyToFile

//---------------------------------------------------------------------------
// 05.09.2010 (ver.1.00)
//     SaveESetSrcToFile
//      ESetSRC
function SaveESetTailToFile(
          var RqESetCTRL : TESetCTRL;  //    ESet
          var RqUFCB     : TUFCB       //    
                              ) : boolean;
begin
   //  
   Result := False;           //  
   if RqUFCB.FlagOpen and (RqUFCB.OpenMode = fmOpenWrite)
   then begin
      //  
      DebugMsgToReport('    ');
      Result := True;
   end; // of if RqUFCB.FlagOpen
end;  // 0f function SaveESetTailToFile

//---------------------------------------------------------------------------
// 05.09.2010 (ver.1.00)
//  ESetSRC   
function SaveESetSrcToFile (
                RqFileName : string;     //     
            var RqESetCTRL : TESetCTRL;  //    ESet
            var RqUFCB     : TUFCB       //    
                          ): boolean;
begin
 Result := False;                        //  
 if Assigned(RqESetCTRL.ESetSRC)
 then begin
    if Length(RqESetCTRL.ESetSRC) >= MinNewESetRow
    then begin
       if not RqUFCB.FlagOpen
       then begin
          //   RqUFCB
          FillChar (RqUFCB, SizeOf(RqUFCB),#0);
          OpenUFCB
              (RqFileName,           //   
               fmOpenWrite,          //  
               True,                 //   
               SizeOf(ESetRecBuf),   //   
               Addr(ESetRecBuf),     //   
               RqUFCB);              //    
       end;
       if RqUFCB.FlagOpen
       then begin
          //     
          if SaveESetHeadToFile(RqESetCTRL, RqUFCB)
          then begin
             if SaveESetBodyToFile(RqESetCTRL, RqUFCB)
             then begin
                if SaveESetTailToFile(RqESetCTRL, RqUFCB)
                then begin
                   //  
                   //   c   RqUFCB
                   ColoseUFCB(RqUFCB);
                   DebugMsgToReport('  '
                                  + '    ');
                   //    
                   Result := True;
                end; // of if SaveESetTailToFile
             end; // of if SaveESetBodyToFile
          end; // of if SaveESetHeadToFile
       end
       else begin
          ErrorMsgToReport
              (True,  //  
               False, //  
              ' OPEN I/O ERROR.'
              + #13#10
              + '     .');
       end; // of if RqUFCB.FlagOpen
    end
    else begin
       MessageDlg('    !'
                  + #13#10 + ' :  \  ',
                  mtWarning, [mbOK], 0);
    end;  // of if Length
  end
  else begin
       MessageDlg('    !'
                  + #13#10 + ' :  \  ',
                  mtWarning, [mbOK], 0);
  end;  // of if Assigned
end; // of procedure CopyFileToESetSRC

//---------------------------------------------------------------------------
// 05.09.2010 (ver.1.00)
//  " " ESetSRC  
procedure SaveAsESetSRC
                (RqFileName     : string;      //   
                 var RqESetCTRL : TESetCTRL);  //    ESet
var FullFileName, ShortFileName : string;
    RunSaveFlag : boolean;
begin
   RunSaveFlag := False;   //  
   FullFileName := Trim(RqFileName);
   if (FullFileName <> '')
   then begin
      HeadMsgToReport('       ');
      if UpperCase(RightStr(FullFileName,4)) <> '.ESM'
      //    (  )  
      then begin
         FullFileName := FullFileName + '.esm';
      end;
      //    
      ShortFileName:= ExtractFileName(FullFileName);
      //    
      if FileExists(FullFileName)
      then begin
         if MessageDlg( ': ' + ShortFileName + #13#10
                      + ' ' + #13#10
                      + '   ?',
                        mtWarning, [mbYes, mbNo], 0) = mrYes
         then RunSaveFlag := True;
      end
      else begin
         //   ,   
         RunSaveFlag := True;
      end;

      if RunSaveFlag
      then begin
          //  
          RqESetCTRL.ESetFFileName := '';
          RqESetCTRL.ESetSFileName := '';
          //     
          if SaveESetSrcToFile
                    (FullFileName,
                     RqESetCTRL,     //    ESet
                     ESetUFCB)       //    
          then begin
             //  
             RqESetCTRL.ESetFFileName := FullFileName;
             RqESetCTRL.ESetSFileName := ShortFileName;
             //    
             InfoMsgToReport
                   (True,   //    
                    False,  //   
                    '    : '
                    + UpperCase(RqESetCTRL.ESetSFileName));
          end;
      end; // of if RunSaveFlag
      TailMsgToReport('     ');
   end; // of if (FullFileName <> '')
end; //of procedure SaveAsESetSRC

//---------------------------------------------------------------------------
// 05.09.2010 (ver.1.00)
//   ESetSRC  
procedure ReSaveESetSRC (var RqESetCTRL : TESetCTRL);
begin
  if (RqESetCTRL.ESetFFileName <> '') and
     (RqESetCTRL.ESetSFileName <> '')
  then  begin
      HeadMsgToReport('       ');
      if FileExists(RqESetCTRL.ESetFFileName)
      then begin
         if SaveESetSrcToFile
                 (RqESetCTRL.ESetFFileName,
                  RqESetCTRL,  //    ESet
                  ESetUFCB)    //    
         then begin
            //  
             InfoMsgToReport
                   (True,   //    
                    False,  //   
                    '    : '
                    + UpperCase(RqESetCTRL.ESetSFileName));
         end;
      end
      else begin
         ErrorMsgToReport
              (True,  //  
               False, //  
              ' .     '
              + #13#10
              + ' :  \   ...');
      end; // of if FileExists
      TailMsgToReport('     ');
  end
  else begin
     MessageDlg('    !'
               + #13#10 + ' :  \   ...',
                 mtWarning, [mbOK], 0);
  end;
end; // of procedure ReSaveESetSRC

//===========================================================================
//===========================================================================

end.
