unit ComplexOp;
// =========================================================================
//       
// =========================================================================
//          :  1.03.
//      :  19.09.2010.
//           :    
// e-mail         :  ravenkey@gmail.com
//     :  , ,    
//
//  :  unit cmplx; :                                                //
//                               e-mail: Sergey.Vilgelm@gmail.com                                           //
//                                : 04.07.2003

// =========================================================================
// =========================================================================
interface
// =========================================================================
// =========================================================================
// -------------------------------------------------------------------------
//   
type
  PReal     = ^TReal;        //     Extended
  TReal     = Extended;      //   TReal
  P2Complex = ^T2Complex;    //      T2Complex
  T2Complex = packed record  //   T2Complex
   //  
   r : TReal;                //    
   i : TReal;                //    
   //  
   m : TReal;                //   
   p : TReal;                //  ( )  
end;

// -------------------------------------------------------------------------
//         T2Complex.
//      
//       ComplexToStr.

 type T2CmpToStrParm = record
    // -----------------------------
    //    
    // 0 =  
    // 1 =  
    VPCrd  : integer;
    // -----------------------------
    //    
    // 0 =  
    // 1 =  Re / Module
    // 2 =  Im / Phase  (  J)
    // 3 =  Im / Phase  (  J)
    VPMod  : integer;
    // ----------------------------
    //  
    // 0 = FIX 6 
    // 1 = FIX 8 
    // 2 = EXP 6 
    // 3 = EXP 8 
    //  
    // 4 = FIX Auto
    // 5 = EXP Auto
    VPPrc  : integer;
    // ----------------------------
    // True  -      
    // False -      
    VPPG   : boolean;
 end; // of type TViewParm

//       
const cPImgPref  = ' + J ';   //    
      cNImgPref  = ' - J ';   //    

// -------------------------------------------------------------------------
//        - 
//   extended  19-20  3.1415926535897932385
const c1mPi      : extended = 3.141592653589793238462643383;
      c2mPi      : extended = 2 * 3.141592653589793238462643383;
      cRadToGrad : extended = 180 / 3.141592653589793238462643383;
      cGradToRad : extended = 3.141592653589793238462643383 / 180;

// =========================================================================
//      
// =========================================================================
//   >>>  
//  X       (Assembler)
procedure DecartToPhaseAsm (var z : T2Complex);
//  X,  X     (Delphi)
function  ModuleDC (var x : T2Complex) : TReal;
//  X,  X     (Assembler)
procedure ModuleADC(x: T2Complex); register;
//       (Delphi)
procedure DecartToPolar (var z : T2Complex);
//       (Assembler)
procedure DecartToPolarAsm (var z : T2Complex);

// -------------------------------------------------------------------------
//   >>>   
//       (Delphi)
procedure PolarToDecart (var z : T2Complex);
//       (Assembler)
procedure PolarToDecartAsm(x : T2Complex); register;

// -------------------------------------------------------------------------
// 
//     (Delphi)
procedure ZeroToComplex (var z : T2Complex);
//    (Delphi)
procedure ComplexToComplex (src : T2Complex; var dest : T2Complex);

// =========================================================================
//   
// =========================================================================
// 
// X + Y    (Delphi)
function SumDC(x, y: T2Complex): T2Complex;
// X + Y    (Assembler)
function SumADC(x, y: T2Complex): T2Complex; register;
// -------------------------------------------------------------------------
// 
// X - Y    (Delphi)
function SubDC(x, y: T2Complex): T2Complex;
// X - Y    (Assembler)
function SubADC(x, y: T2Complex): T2Complex; register;
// -------------------------------------------------------------------------
// 
// X * Y    (Delphi)
function MulDC(x, y: T2Complex): T2Complex;
// X * Y     (Delphi)
function MulPC(x, y: T2Complex): T2Complex;
// X * Y    (Assembler)
function MulADC(x, y: T2Complex): T2Complex; register;
// -------------------------------------------------------------------------
// 
// X / Y    (Delphi)
function DivDC(x, y: T2Complex): T2Complex;
// X / Y     (Delphi)
function DivPC(x, y: T2Complex): T2Complex;
// X / Y    (Assembler)
function DivADC(x, y: T2Complex): T2Complex; register;

// =========================================================================
//        
// =========================================================================
//      (Delphi)
// : Coeff := Coeff - (Scale * MCoeff)
procedure NewGausseCoeff (const Scale, MCoeff : T2Complex;
                          var   Coeff : T2Complex);
// -------------------------------------------------------------------------
//     (Delphi)
// : PSum := PSum + Coeff * X
procedure PartPolynom (const Coeff, X : T2Complex; var PSum : T2Complex);
// -------------------------------------------------------------------------
//       (Delphi)
// :  Root = ( Y - PSum ) / Coeff
procedure NextRoot (const Y, PSum, Coeff : T2Complex; var Root : T2Complex);

// =========================================================================
//        T2Complex
// =========================================================================
//        (Delphi)
function ComplexToStr (RqX : T2Complex; RqVP : T2CmpToStrParm): string;

// =========================================================================
// =========================================================================
implementation
uses Math, SysUtils, Dialogs;
// =========================================================================
// =========================================================================

// =========================================================================
//      
// =========================================================================
// 19.09.2010 ()
//         (Assembler)
procedure DecartToPhaseAsm (var z : T2Complex);
asm
  FINIT                    //      (FPU)
                           //   FPU   
  FLD   T2Complex.i [EAX]  // (z.i)
  FLD   T2Complex.r [EAX]  // (z.r) (z.i)
  FPATAN                   // arctan (z.i / z.r) -> ([-Pi]..0..Pi)
  FSTP  T2Complex.p [EAX]  // (Empty)

  //    FPATAN:
  //  Re     Im    Ph(rad)   Ph()
  //  0      0     0         0
  //  1      1     Pi/4      45
  //  0      1     Pi/2      90
  // -1      1     Pi(3/4)   135
  // -1      0     2Pi       180
  // -1     -1    -Pi(3/4)  -135
  //  0     -1    -Pi/2     -90
  //  1     -1    -Pi/4     -45
end;
// -------------------------------------------------------------------------
// 14.07.2010 ()
//   X,  X    
function ModuleDC (var x : T2Complex) : TReal;
begin
  with x do
  begin
    m := sqrt(r * r + i * i);
    Result := m;
  end;
end;
// -------------------------------------------------------------------------
// 14.07.2010 ()
//   X,  X     (Assembler)
procedure ModuleADC(x: T2Complex); register;
asm
  FINIT                   //      (FPU)
                          //   FPU   
  FLD T2Complex.r [EAX]   // (x.r)
  FLD  ST(0)              // (x.r) (x.r)
  FMUL                    // (x.r * x.r)
  FLD T2Complex.i [EAX]   // (x.i) (x.r * x.r)
  FLD  ST(0)              // (x.i) (x.i) (x.r * x.r)
  FMUL                    // (x.i * x.i) (x.r * x.r)
  FADD                    // (x.i * x.i + x.r * x.r)
  FSQRT                   // sqrt(x.i * x.i + x.r * x.r)
  FSTP T2Complex.m [EAX]  // [empty]
end;
// -------------------------------------------------------------------------
//      
procedure DecartToPolar (var z : T2Complex);
var VPI : extended;
begin
  with z do begin
   //    (  )
   m := sqrt(r * r + i * i);
   if (m > 1e-10) and (m >= Abs(i)) then begin
     //    I -  
     p := arcsin(abs(i/m));
     VPI := Pi;
     if i > 0 then begin
        if r < 0 then p := VPI - p; // II - 
     end else begin
        // III, IV - 
        if r < 0
        then p := VPI + p           // III - 
        else p := (2 * VPI) - p;    // IV - 
     end;
     if p >= (2 * VPI) then p := p - (2 * VPI);
   end else begin
      //   
      m := 0;
      p := 0;
   end;
  end;
end;
// -------------------------------------------------------------------------
// 19.09.2010 ()
//       (Assembler)
procedure DecartToPolarAsm (var z : T2Complex);
asm
  FINIT                    //      (FPU)
                           //   FPU   
  FLD   T2Complex.i [EAX]  // (z.i)
  FLD   T2Complex.r [EAX]  // (z.r) (z.i)
  //    
  FLD   ST(1)              // (z.i) (z.r) (z.i)
  FLD   ST(1)              // (z.r) (z.i) (z.r) (z.i)
  FPATAN                   // ({-Pi}..0..Pi) (z.r) (z.i)
  FSTP  T2Complex.p [EAX]  // (z.r) (z.i)
  //  
  FLD  ST(0)              // (z.r) (z.r) (z.i)
  FMUL                    // (z.r * z.r) (z.i)
  FXCH ST(1)              // (z.i) (z.r * z.r)
  FLD  ST(0)              // (z.i) (z.i) (z.r * z.r)
  FMUL                    // (z.i * z.i) (z.r * z.r)
  FADD                    // (z.i * z.i + z.r * z.r)
  FSQRT                   //  sqrt(z.i * z.i + z.r * z.r)
  FSTP T2Complex.m [EAX]  // [empty]
end;

// =========================================================================
// 23.08.2010 ()
//      
procedure PolarToDecart (var z : T2Complex);
begin
  with z do begin
   r := m * cos(p);
   i := m * sin(p);
  end;
end;
// -------------------------------------------------------------------------
// 14.07.2010 ()
//       (Assembler)
procedure PolarToDecartAsm(x : T2Complex); register;
asm
  FINIT                    //      (FPU)
                           //   FPU   
  FLD   T2Complex.m [EAX]  // (x.m)
  FLD   T2Complex.p [EAX]  // (x.p) (x.m)
  FSINCOS                  // (cos(x.p)) (sin(x.p)) (x.m)
  FMUL  ST, ST(2)          // (x.m * cos(x.p)) (sin(x.p)) (x.m)
  FSTP  T2Complex.r [EAX]  // (sin(x.p)) (x.m)
  FMUL                     // (x.m * sin(x.p))
  FSTP  T2Complex.i [EAX]  // [empty]
end;

// =========================================================================
// 27.08.2010 ()
//   
procedure ZeroToComplex (var z : T2Complex);
begin
  FillChar(z, SizeOf(T2Complex), #0);
end;
// -------------------------------------------------------------------------
// 27.08.2010 ()
//   
procedure ComplexToComplex (src : T2Complex; var dest : T2Complex);
begin
   // Copies bytes from a source to a destination.
   Move(src, dest, SizeOf(T2Complex));
end;

// =========================================================================
//   
// =========================================================================
// 
// -------------------------------------------------------------------------
// 14.07.2010 ()
// X + Y   
function SumDC(x, y: T2Complex): T2Complex;
begin
with result do
begin
   r := x.r + y.r;
   i := x.i + y.i;
end;
end;
// -------------------------------------------------------------------------
// 14.07.2010 ()
// X + Y    (Assembler)
function SumADC(x, y: T2Complex): T2Complex; register;
asm
  FINIT                   //      (FPU)
                          //   FPU   
  FLD T2Complex.r [EAX]   // (x.r)
  FLD T2Complex.r [EDX]   // (y.r) (x.r)
  FADD                    // (x.r + y.r)
  FSTP T2Complex.r [ECX]  // [empty]
  FLD T2Complex.i [EAX]   // (x.i)
  FLD T2Complex.i [EDX]   // (y.i) (x.i)
  FADD                    // (x.i + y.i)
  FSTP T2Complex.i [ECX]  // [empty]
end;

// =========================================================================
// 
// -------------------------------------------------------------------------
// 14.07.2010 ()
function SubDC(x, y: T2Complex): T2Complex;
begin
with result do
begin
   r := x.r - y.r;
   i := x.i - y.i;
end;
end;
// -------------------------------------------------------------------------
// 14.07.2010 ()
// X - Y    (Assembler)
function SubADC(x, y: T2Complex): T2Complex; register;
asm
  FINIT                   //      (FPU)
                          //   FPU   
  FLD T2Complex.r [EAX]   // (x.r)
  FLD T2Complex.r [EDX]   // (y.r) (x.r)
  FSUB                    // (x.r - y.r)
  FSTP T2Complex.r [ECX]  // [empty]
  FLD T2Complex.i [EAX]   // (x.i)
  FLD T2Complex.i [EDX]   // (y.i) (x.i)
  FSUB                    // (x.i - y.i)
  FSTP T2Complex.i [ECX]  // [empty]
end;

// =========================================================================
// 
// -------------------------------------------------------------------------
// 14.07.2010 ()
// X * Y   
function MulDC(x, y: T2Complex): T2Complex;
begin
with result do
begin
   r := x.r * y.r - x.i * y.i;
   i := x.r * y.i + x.i * y.r;
end;
end;
// -------------------------------------------------------------------------
// 14.07.2010 ()
// X * Y   
function MulPC(x, y: T2Complex): T2Complex;
begin
with result do
begin
  m := x.m * y.m;
  p := x.p + y.p;
end;
end;
// -------------------------------------------------------------------------
// 19.09.2010 ()
// X * Y   
function MulADC(x, y: T2Complex): T2Complex; register;
// Result.r := x.r * y.r - x.i * y.i;
// Result.i := x.r * y.i + x.i * y.r;
asm
  FINIT                   //      (FPU)
                          //   FPU   
  FLD  T2Complex.i [EAX]  // (x.i)
  FLD  T2Complex.i [EDX]  // (y.i) (x.i)
  FLD  T2Complex.r [EAX]  // (x.r) (y.i) (x.i)
  FLD  T2Complex.r [EDX]  // (y.r) (x.r) (y.i) (x.i)
  FLD  ST(1)              // (x.r) (y.r) (x.r) (y.i) (x.i)
  FMUL ST, ST(1)          // (x.r * y.r) (y.r) (x.r) (y.i) (x.i)
  FLD  ST(3)              // (y.i) (x.r * y.r) (y.r) (x.r) (y.i) (x.i)
  FMUL ST, ST(5)          // (x.i * y.i) (x.r * y.r) (y.r) (x.r) (y.i) (x.i)
  FSUB                    // (Result.r ) (y.r) (x.r) (y.i) (x.i)
  FSTP T2Complex.r [ECX]  // (y.r) (x.r) (y.i) (x.i)
  FXCH ST(2)              // (y.i) (x.r) (y.r) (x.i)
  FMUL                    // (y.i * x.r) (y.r) (x.i)
  FXCH ST(2)              // (x.i) (y.r) (y.i * x.r)
  FMUL                    // (x.i * y.r) (y.i * x.r)
  FADD                    // (Result.i)
  FSTP T2Complex.i [ECX]  // [Empty]
end;

// =========================================================================
// 
// -------------------------------------------------------------------------
// 14.07.2010 ()
// X / Y   
function DivDC(x, y: T2Complex): T2Complex;
var d : TReal;
begin
  with result do
  begin
    d := y.r * y.r + y.i * y.i;
    if d <> 0 then begin
      r := (x.r * y.r + x.i * y.i)/d;
      i := (x.i * y.r - x.r * y.i)/d;
    end else begin
      r := 0;
      i := 0;
      ShowMessage ('    ');
    end;
  end;
end;
// -------------------------------------------------------------------------
// 14.07.2010 ()
// X / Y   
function DivPC(x, y: T2Complex): T2Complex;
begin
 if y.m <> 0 then begin
   with result do
   begin
     m := x.m / y.m;
     p := x.p - y.p;
   end;
 end else begin
   result.m := 0;
   result.p := 0;
   ShowMessage ('    ');
 end;
end;
// -------------------------------------------------------------------------
// 14.07.2010 ()
// X / Y   
function DivADC(x, y: T2Complex): T2Complex; register;
// k := 1 / (y.r * y.r + y.i * y.i);
// Result.r := (x.r * y.r + x.i * y.i) * k;
// Result.i := (x.i * y.r - x.r * y.i) * k;
asm
   FINIT                  //      (FPU)
                          //   FPU   
   FLD T2Complex.r [EDX]  // (y.r)
   FLD ST(0)              // (y.r) (y.r)
   FMUL ST, ST            // (y.r * y.r) (y.r)
   FLD T2Complex.i [EDX]  // (y.i) (y.r * y.r) (y.r)
   FXCH ST(1)             // (y.r * y.r) (y.i) (y.r)
   FLD ST(1)              // (y.i) (y.r * y.r) (y.i) (y.r)
   FMUL ST, ST            // (y.i * y.i) (y.r * y.r) (y.i) (y.r)
   FADD                   // (y.i * y.i + y.r * y.r) (y.i) (y.r)
   FLD1                   // (1) (y.i * y.i + y.r * y.r) (y.i) (y.r)
   FDIVR                  // (k) (y.i) (y.r)
   //       NAN
   FLD T2Complex.i [EAX]  // (x.i) (k) (y.i) (y.r)
   FLD T2Complex.r [EAX]  // (x.r) (x.i) (k) (y.i) (y.r)
   FXCH ST(2)             // (k) (x.i) (x.r) (y.i) (y.r)
   FLD ST(1)              // (x.i) (k) (x.i) (x.r) (y.i) (y.r)
   FMUL ST, ST(4)         // (x.i * y.i) (k) (x.i) (x.r) (y.i) (y.r)
   FLD ST(3)              // (x.r) (x.i * y.i) (k) (x.i) (x.r) (y.i) (y.r)
   FMUL ST, ST(6)         // (x.r * y.r) (x.i * y.i) (k) (x.i) (x.r) (y.i) (y.r)
   FADD                   // (x.r * y.r + x.i * y.i) (k) (x.i) (x.r) (y.i) (y.r)
   FMUL ST, ST(1)         // (Result.r) (k) (x.i) (x.r) (y.i) (y.r)
   FSTP T2Complex.r [ECX] // (k) (x.i) (x.r) (y.i) (y.r)
   FXCH ST(4)             // (y.r) (x.i) (x.r) (y.i) (k)
   FMUL                   // (y.r * x.i) (x.r) (y.i) (k)
   FXCH ST(2)             // (y.i) (x.r) (y.r * x.i) (k)
   FMUL                   // (y.i * x.r) (y.r * x.i) (k)
   FSUB                   // (y.r * x.i - y.i * x.r) (k)
   FMUL                   // (Result.i)
   FSTP T2Complex.i [ECX] // [empty]
end;

// =========================================================================
//        
// =========================================================================
// 23.08.2010 ()
//     
// : Coeff := Coeff - (Scale * MCoeff)
procedure NewGausseCoeff (const Scale, MCoeff : T2Complex;
                          var   Coeff : T2Complex);
begin
   Coeff.r := Coeff.r - (Scale.r * MCoeff.r - Scale.i * MCoeff.i);
   Coeff.i := Coeff.i - (Scale.r * MCoeff.i + Scale.i * MCoeff.r);
end;

// -------------------------------------------------------------------------
// 23.08.2010 ()
//    
// : PSum := PSum + Coeff * X
procedure PartPolynom (const Coeff, X : T2Complex; var PSum : T2Complex);
begin
   PSum.r := PSum.r + (Coeff.r * X.r - Coeff.i * X.i);
   PSum.i := PSum.i + (Coeff.r * X.i + Coeff.i * X.r);
end;

// -------------------------------------------------------------------------
// 23.08.2010 ()
//      
// :  Root = ( Y - PSum ) / Coeff
procedure NextRoot (const Y, PSum, Coeff : T2Complex; var Root : T2Complex);
begin
   Root.r := Y.r - PSum.r;
   Root.i := Y.i - PSum.i;
   //    Root.m  Root.p
   //   
   Root.m := Coeff.r * Coeff.r + Coeff.i * Coeff.i;
   if Root.m > 0 then begin
      Root.p := ( Root.r * Coeff.r + Root.i * Coeff.i ) / Root.m;
      Root.i := ( Root.i * Coeff.r - Root.r * Coeff.i ) / Root.m;
      Root.r := Root.p;
   end else begin
      Root.r := 0;
      Root.i := 0;
      MessageDlg('     .'
                 + #13#10 +
                 '     .',
                 mtWarning, [mbOk], 0);
   end;
   //   
   Root.m := 0;
   Root.p := 0;
end;

// =========================================================================
//        T2Complex
// =========================================================================

//       
function ReToStr (RqX : T2Complex; RqFormStr : string) : string;
begin
  Result := FormatFloat(RqFormStr, RqX.r);
end;

//        (  J)
function JImToStr (RqX : T2Complex; RqFormStr : string) : string;
begin
  if RqX.i >= 0
  then Result :=  cPImgPref  + FormatFloat(RqFormStr,Abs(RqX.i))
  else Result :=  cNImgPref + FormatFloat(RqFormStr,Abs(RqX.i));
end;

//        (  J)
function ImToStr (RqX : T2Complex; RqFormStr : string) : string;
begin
  Result := FormatFloat(RqFormStr,Abs(RqX.i));
end;

//        
function DecartToStr (RqX : T2Complex; RqFormStr : string) : string;
begin
  Result := ReToStr (RqX, RqFormStr) + JImToStr(RqX, RqFormStr);
end;

//      
function MdToStr (RqX : T2Complex; RqFormStr : string) : string;
begin
   Result := FormatFloat(RqFormStr, RqX.m)
end;

//       (  J   .)
function JPhToStr (RqX       : T2Complex;   //  
                   RqVPPG    : boolean;     //    
                   RqFormStr : string       //  
                   ) : string;
begin
  if RqX.p >= 0
  then begin
      //   (  )
      if RqVPPG
      //    
      then Result :=  cPImgPref
                    + FormatFloat(RqFormStr, cRadToGrad * Abs(RqX.p))
                    + #176  //  
      //    
      else Result :=  cPImgPref
                    + FormatFloat(RqFormStr, Abs(RqX.p));
  end
  else begin
      //   (  )
      if RqVPPG
      //    
      then Result :=  cNImgPref
                    + FormatFloat(RqFormStr, cRadToGrad * Abs(RqX.p))
                    + #176  //  
      //    
      else Result :=  cNImgPref
                    + FormatFloat(RqFormStr, Abs(RqX.p));
  end;
end;

//       (  J)
function PhToStr (RqX       : T2Complex;  //  
                  RqVPPG    : boolean;    //    
                  RqFormStr : string      //  
                  ) : string;
begin
  if RqVPPG
  //    
  then Result :=  FormatFloat(RqFormStr, cRadToGrad * RqX.p)
  //    
  else Result :=  FormatFloat(RqFormStr, RqX.p);
end;

//        
function PolarToStr (RqX : T2Complex; RqVPPG : boolean; RqFormStr : string) : string;
begin
  Result :=  MdToStr  (RqX, RqFormStr)
           + ' Exp ('
           + JPhToStr (RqX, RqVPPG, RqFormStr) + ' )';
end;

//       
function ComplexToStr (RqX : T2Complex; RqVP : T2CmpToStrParm): string;
var FormStr : string;  //     FormatFloat
begin
  case RqVP.VPPrc of
    0 : FormStr := '###############0.000000';     // FIX 6 
    1 : FormStr := '###############0.00000000';   // FIX 8 
    2 : FormStr := '0.00000e+000';                // EXP 6 
    3 : FormStr := '0.0000000e+000';              // EXP 8 
    //  
    4 : FormStr := '###############0.###############0';  // FIX Auto
    5 : FormStr := '0.################e+000';            // EXP Auto
    else FormStr := '0.################e+000';           // EXP Auto
  end;
  with RqVP do begin
     case VPCrd of
     1 :  begin
            //  
            case RqVP.VPMod of
             1 : Result := MdToStr    (RqX, FormStr);       //  Module
             2 : Result := JPhToStr   (RqX, VPPG, FormStr); //  Phase (J)
             3 : Result := PhToStr    (RqX, VPPG, FormStr); //  Phase ( J)
            else Result := PolarToStr (RqX, VPPG, FormStr); // 
            end;
         end;
     else begin
          //  
          case RqVP.VPMod of
             1 : Result := ReToStr    (RqX, FormStr);      //  Re
             2 : Result := JImToStr   (RqX, FormStr);      //  Im (J)
             3 : Result := ImToStr    (RqX, FormStr);      //  Im ( J)
            else Result := DecartToStr(RqX, FormStr);      // 
          end;
        end;
     end; // of case RqVP.VCoordinates
  end;  // of with RqVP
end; // of function

// =========================================================================
//
// =========================================================================


end.



