unit CommonService;

interface
uses Windows, StdCtrls, Controls, Dialogs, SysUtils, Graphics, StrUtils,
     MAINDATA, Reports, ComplexOp;

//       
// Type for User File Control Block
type TUFCB    = record
   //   
   FileName   : string;        //    
   OpenMode   : word;          //    FileMode
   BufRecSize : LongInt;       //    
   pBufRec    : pointer;       //     
   SFCB       : file;          //  SFCB. System File Control Block
   FlagOpen   : boolean;       //  True,  SFCB  
   //     I/O 
   LastCode   : integer;       //     I/O 
   NumRecWR   : LongInt;       //      
   LastMess   : string;        //    I/O 
end;

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//  Integer   TEdit     .
//           RqMsg
//  ShowMessage.
function LoadIntegerFromEdit (
                 RqEdit : TEdit;    // TEdit  
                 RqMsg  : boolean;  //  ShowMessage
                 var OutInteger : Integer) : boolean;

//---------------------------------------------------------------------------
//  Extended   TEdit     .
//           RqMsg
//  ShowMessage.
function LoadFloatFromEdit (
                 RqEdit : TEdit;    // TEdit  
                 RqMsg  : boolean;  //  ShowMessage
                 var OutExtended : Extended) : boolean;

// ==========================================================================
//   
function TestFileExists (RqFileName : string) : boolean;

//---------------------------------------------------------------------------
//      RqUFCB
function OpenUFCB
              (RqFileName : string;         //   
               RqFileMode : word;           //  
               RqRewrite  : boolean;        //    
               RqBufSize  : LongInt;        //    ( )
               RqBufPtr   : pointer;        //   
           var RqUFCB     : TUFCB           //   
               )  : boolean;
//---------------------------------------------------------------------------
//   c   RqUFCB
procedure ColoseUFCB(var RqUFCB : TUFCB);

//---------------------------------------------------------------------------
//      UFCB
function WriteOneRec(var RqUFCB : TUFCB): boolean;

//---------------------------------------------------------------------------
//      UFCB
function ReadOneRec(var RqUFCB : TUFCB): boolean;

//===========================================================================
implementation
//===========================================================================

// ---------------------------------------------------------------------
//  Integer   TEdit     .
//           RqMsg
//  ShowMessage.
function LoadIntegerFromEdit (
                 RqEdit : TEdit;    // TEdit  
                 RqMsg  : boolean;  //  ShowMessage
                 var OutInteger : Integer) : boolean;
begin
    Result := False;             //  
    try
      OutInteger := StrToInt(RqEdit.Text);
      RqEdit.Color := clWindow;  //   
      Result := True;            //  
    except
      //  :
      RqEdit.Color := RGB(255,200,200);
      if RqMsg then ShowMessage('    Integer - ');
    end;
end;

// ---------------------------------------------------------------------
//  Extended   TEdit     .
//           RqMsg
//  ShowMessage.
function LoadFloatFromEdit (
                 RqEdit : TEdit;    // TEdit  
                 RqMsg  : boolean;  //  ShowMessage
                 var OutExtended : Extended) : boolean;
begin
    Result := False;             //  
    try
      OutExtended := StrToFloat(RqEdit.Text);
      RqEdit.Color := clWindow;  //   
      Result := True;            //  
    except
      //  :
      RqEdit.Color := RGB(255,200,200);
      if RqMsg then ShowMessage('    Extended - ');
    end;
end;

// ==========================================================================
//   
// ==========================================================================
// 01.09.2010 (ver 1.00)
//   
function TestFileExists (RqFileName : string) : boolean;
var Ok : boolean;
begin
  Result := False;  //  
  try
     Ok := FileExists(RqFileName);
     Result := Ok; //  
  except
     //      
     //       .
  end;
end; // of function TestFileExists

// --------------------------------------------------------------------------
// 01.09.2010 (ver 1.00)
//      RqUFCB
function OpenUFCB
              (RqFileName : string;         //   
               RqFileMode : word;           //  
               RqRewrite  : boolean;        //    
               RqBufSize  : LongInt;        //    ( )
               RqBufPtr   : pointer;        //   
           var RqUFCB     : TUFCB           //   
               )  : boolean;
begin
   Result := False;                         //  
   {$I-}
   //      I/O
   Assign(RqUFCB.SFCB, RqFileName);         //   SFCB  
   FileMode := RqFileMode;                  //  
   if (RqFileMode = fmOpenWrite) or
      (RqFileMode = fmOpenReadWrite)
   then begin
     if RqRewrite
     then Rewrite (RqUFCB.SFCB, RqBufSize)  //    
     else Reset(RqUFCB.SFCB, RqBufSize);    //  
    end
    else Reset(RqUFCB.SFCB, RqBufSize);     //  
   RqUFCB.LastCode := IOResult();           //    I/O
   if RqUFCB.LastCode = 0                   //    I/O
   then begin
       Result := True;   //  
       RqUFCB.LastMess := SysErrorMessage(RqUFCB.LastCode);
       //  RqUFCB
       RqUFCB.FileName   := RqFileName;
       RqUFCB.OpenMode   := RqFileMode;
       RqUFCB.BufRecSize := RqBufSize;
       RqUFCB.pBufRec    := RqBufPtr;
   end
   else begin
       RqUFCB.LastMess := 'Open ERROR :'
                        + SysErrorMessage(RqUFCB.LastCode);
       //  RqUFCB
       RqUFCB.FileName   := '';
       RqUFCB.OpenMode   := 0;
       RqUFCB.BufRecSize := 0;
       RqUFCB.pBufRec    := nil;
   end;
   {$I+}
   //     I/O
   RqUFCB.FlagOpen := Result;
end; // of function OpenUFCB

//---------------------------------------------------------------------------
// 01.09.2010 (ver 1.00)
//   c   RqUFCB
procedure ColoseUFCB(var RqUFCB : TUFCB);
begin
   Close(RqUFCB.SFCB);
   RqUFCB.FlagOpen := False;  // SFCB - 
   if RqUFCB.LastCode <> 0
   then begin
       //   I/O   
       DebugMsgToReport('I/O - ERROR. LastErrorCode = '
                        + IntToStr(RqUFCB.LastCode)
                        + ' >> ' + RqUFCB.LastMess);
       ErrorMsgToReport (True,  //    
                         False, //   
                         ' ERROR (Report from ColoseUFCB ):'
                         + #13#10
                         + '  /  .');
   end;
end; // of procedure ColoseUFCB

//---------------------------------------------------------------------------
// 01.09.2010 (ver 1.00)
//      UFCB
function WriteOneRec(var RqUFCB : TUFCB): boolean;
const Num = 1;        //      
begin
  Result := False;     //  
  with RqUFCB do
  begin
     if ((OpenMode = fmOpenWrite) or (OpenMode = fmOpenReadWrite)) and
         FlagOpen
     then begin
       {$I-}  //      I/O
        BlockWrite(SFCB, pBufRec^, Num, NumRecWR);
        LastCode := IOResult();     //    I/O
        LastMess := SysErrorMessage(LastCode);
        {$I+}  //     I/O
        if (LastCode = 0) and (NumRecWR = Num)
        then Result := True
        else begin
           if (NumRecWR <> Num)
           then begin
             LastCode := 199;  //  
             LastMess := '    : '
                       + '  = ' + IntToStr (Num)
                       + '  = ' + IntToStr (NumRecWR);
           end;
        end;
     end;
  end;
end; // of function WriteOneRec

//---------------------------------------------------------------------------
// 01.09.2010 (ver 1.00)
//      UFCB
function ReadOneRec(var RqUFCB : TUFCB): boolean;
const Num = 1;        //      
begin
  Result := False;     //  
  with RqUFCB do
  begin
     if ((OpenMode = fmOpenRead) or (OpenMode = fmOpenReadWrite)) and
         FlagOpen
     then begin
       {$I-}  //      I/O
        BlockRead(SFCB, pBufRec^, Num, NumRecWR);
        LastCode := IOResult();     //    I/O
        LastMess := SysErrorMessage(LastCode);
        {$I+}  //     I/O
        if (LastCode = 0) and (NumRecWR = Num)
        then Result := True
        else begin
           if (NumRecWR <> Num)
           then begin
             LastCode := 199;  //  
             LastMess := '    : '
                       + '  = ' + IntToStr (Num)
                       + '  = ' + IntToStr (NumRecWR);
           end;
        end;
     end;
  end;
end; // of function ReadOneRec

// ==========================================================================
//---------------------------------------------------------------------------
// 01.09.2010
//      (    )
procedure AddRecToFile(var RqUFCB : TUFCB);
var NumRead, NumWritten : Integer;    // Read / Write counter
begin
   if RqUFCB.FlagOpen
   then begin
      //      
      while not Eof(RqUFCB.SFCB)
      do begin
         BlockRead (RqUFCB.SFCB, RqUFCB.pBufRec^, 1, NumRead);
      end;
      //    ,     
      if Eof(RqUFCB.SFCB)
      then begin
         BlockWrite(RqUFCB.SFCB, RqUFCB.pBufRec^, 1, NumWritten);
         //    ,  .  
         if NumWritten = 1
         then begin
            //RqUFCB.MaxRecInd := RqUFCB.MaxRecInd + 1;
         end;
      end;
   end;
end;


end.
