unit Main;

interface

// =======================================================================
//       SwitchScope
// =======================================================================

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Clipbrd, ComCtrls, ImgLoadSave01,
  CustomScope01, LineScope03, RingScope03, SwitchScope03, ExtDlgs;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Panel1: TPanel;
    bttStyle: TButton;
    bttVisible: TButton;
    bttCompact: TButton;
    bttTransporent: TButton;
    edName: TEdit;
    trbarNumLPF: TTrackBar;
    CbBoxWall: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    ftxtNumLPF: TStaticText;
    Panel2: TPanel;
    trbarValue: TTrackBar;
    CheckBox1: TCheckBox;
    Label4: TLabel;
    stxtValue: TStaticText;
    Panel3: TPanel;
    ScrollBox1: TScrollBox;
    Image1: TImage;
    DlgOpenPicture1: TOpenPictureDialog;
    CbBoxSet: TComboBox;
    bttSet: TButton;
    Label6: TLabel;
    stxtXBeg: TStaticText;
    stxtYBeg: TStaticText;
    Label7: TLabel;
    Label8: TLabel;
    CbBoxScopes: TComboBox;
    bttLoadPicture: TButton;
    bttCreate: TButton;
    bttFree: TButton;
    Label9: TLabel;
    edSet: TEdit;
    bttSaveImg: TButton;
    Label5: TLabel;
    Label10: TLabel;
    CkBoxOnOffHints: TCheckBox;

    procedure bttSaveImgClick(Sender: TObject);

    procedure bttStyleClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bttVisibleClick(Sender: TObject);
    procedure bttCompactClick(Sender: TObject);
    procedure bttTransporentClick(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure edNameChange(Sender: TObject);
    procedure trbarValueChange(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure trbarNumLPFChange(Sender: TObject);
    procedure CbBoxWallClick(Sender: TObject);
    procedure bttSetClick(Sender: TObject);
    procedure bttCreateClick(Sender: TObject);
    procedure bttFreeClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure bttLoadPictureClick(Sender: TObject);
    procedure CbBoxSetClick(Sender: TObject);
    procedure CkBoxOnOffHintsClick(Sender: TObject);
  private
    { Private declarations }
    //      
    procedure ShowEdSet();
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
// =======================================================================
implementation
{$R *.dfm}
// =======================================================================

//  -  /  
var ImgLoadSave1 : TLoadSaveImage;   

var Scope         : TCustomScope;

// =======================================================================
//     
// =======================================================================
// -----------------------------------------------------------------------
//    
function GetApplicationDirectory() : string;
begin
   Result := Application.ExeName;
   Result := ExtractFileDir(Result);
end;
// -----------------------------------------------------------------------
//   edt.Text   Rez
function TryEditToExt(edt : TEdit; var Rez : extended) : boolean;
begin
    Result := False;
    try
      edt.Color := clWindow;
      Rez := StrToFloat(edt.Text);
      Result := True;
    except
      edt.Color := RGB(255, 200,200);
      ShowMessage('    ');
    end;
end;
 // =======================================================================
//    
// =======================================================================
// -----------------------------------------------------------------------
//      
procedure TForm1.ShowEdSet();
begin
  edSet.Text := '';
  if not Assigned(Scope) then Exit;
  case CbBoxSet.ItemIndex of
  0 : edSet.Text := FloatToStr(Scope.MinScope); //    
  1 : edSet.Text := FloatToStr(Scope.M2Wall);   //    
  2 : edSet.Text := FloatToStr(Scope.M1Wall);   //    
  3 : edSet.Text := FloatToStr(Scope.MaxScope); //    
  4 : edSet.Text := FloatToStr(Scope.P2Wall);   //    
  5 : edSet.Text := FloatToStr(Scope.P1Wall);   //    
  end;
end;
// -----------------------------------------------------------------------
//  /  HINTs
procedure TForm1.CkBoxOnOffHintsClick(Sender: TObject);
var Ind : integer;
begin
    if ComponentCount <= 0 then Exit;
    for Ind := 0 to ComponentCount -1
    do begin
      if Components[Ind] is TButton
      then TButton(Components[Ind]).ShowHint := CkBoxOnOffHints.Checked;
      if Components[Ind] is TEdit
      then TEdit(Components[Ind]).ShowHint := CkBoxOnOffHints.Checked;
      if Components[Ind] is TComboBox
      then TComboBox(Components[Ind]).ShowHint := CkBoxOnOffHints.Checked;
      if Components[Ind] is TStaticText
      then TStaticText(Components[Ind]).ShowHint := CkBoxOnOffHints.Checked;
    end;
end;
// -----------------------------------------------------------------------
//   
procedure TForm1.bttLoadPictureClick(Sender: TObject);
begin
    //   
    if not Assigned(ImgLoadSave1) then Exit;
    DlgOpenPicture1.InitialDir := GetApplicationDirectory() + '\PICTUREs';
    DlgOpenPicture1.Filter :=  'JPEG Image File (*.jpg)|*.jpg';
    if DlgOpenPicture1.Execute
    then begin
       if ImgLoadSave1.LoadImgFromFile(DlgOpenPicture1.FileName, Image1)
       then begin
          Image1.Height := Image1.Picture.Height;
          Image1.Width := Image1.Picture.Width;
       end;
    end;
end;
// -----------------------------------------------------------------------
//   
procedure TForm1.bttSaveImgClick(Sender: TObject);
begin
  ImgLoadSave1.DlgSaveImgToFile(Image1);
end;

// =======================================================================
//  /  
// =======================================================================
procedure TForm1.FormCreate(Sender: TObject);
var wFileName : string;
begin
    //   / 
    ImgLoadSave1 := TLoadSaveImage.Create(nil,nil);
    wFileName := GetApplicationDirectory() + '\PICTUREs\Default.jpg';
    if ImgLoadSave1.LoadImgFromFile(wFileName, Image1)
    then begin
          Image1.Height := Image1.Picture.Height;
          Image1.Width := Image1.Picture.Width;
    end;
end;
// -----------------------------------------------------------------------
procedure TForm1.FormDestroy(Sender: TObject);
begin
   bttFreeClick(nil);
   ImgLoadSave1.Free
end;

// =======================================================================
// / 
// =======================================================================
// -----------------------------------------------------------------------
//   
procedure TForm1.bttCreateClick(Sender: TObject);
var wXBeg, wYBeg : integer;
begin
   if not Assigned(Scope)
   then begin
      wXBeg := 170;
      wYBeg := 100;
      case CbBoxScopes.ItemIndex of
      0 : Scope := TLineScope.Create(Image1,   wXBeg, wYBeg);
      1 : Scope := TRingScope.Create(Image1,   wXBeg, wYBeg);
      2 : Scope := TSwitchScope.Create(Image1, wXBeg, wYBeg);
      end;
      // ----------------------
      Scope.MaxScope :=  50;;
      Scope.MinScope := -50;
      Scope.P2Wall  := 0.9 * Scope.MaxScope;
      Scope.P1Wall  := 0.7 * Scope.MaxScope;
      Scope.M2Wall  := 0.9 * Scope.MinScope;
      Scope.M1Wall  := 0.7 * Scope.MinScope;
      // ----------------------
      Scope.ScopeStyle := ssArc;
      Scope.ScopeName := '. 0';
      // ----------------------
      stxtXBeg.Caption := IntToStr(wXBeg);
      stxtYBeg.Caption := IntToStr(wYBeg);
      //      
      ShowEdSet();
      trbarValue.Max := Round(1.1 * Scope.MaxScope);
      trbarValue.Min := Round(1.1 * Scope.MinScope);
   end;
end;
// -----------------------------------------------------------------------
//   
procedure TForm1.bttFreeClick(Sender: TObject);
begin
   if Assigned(Scope)
   then begin
      if Scope is TLineScope
      then begin
         TLineScope(Scope).Free;
         Scope := nil;
         Exit;
      end;
      if Scope is TRingScope
      then begin
         TRingScope(Scope).Free;
         Scope := nil;
         Exit;
      end;
      if Scope is TSwitchScope
      then begin
         TSwitchScope(Scope).Free;
         Scope := nil;
         Exit;
      end;
   end;
   stxtXBeg.Caption := '';
   stxtYBeg.Caption := '';
   edSet.Text := '';
end;
// =======================================================================
//      
// =======================================================================
//   
procedure TForm1.trbarValueChange(Sender: TObject);
begin
   if not Assigned(Scope) then Exit;
   if CheckBox1.Checked
   then Scope.Value := trbarValue.Position * (1 + (0.1 * random - 0.05))
   else Scope.Value := trbarValue.Position;
   stxtValue.Caption := IntToStr(trbarValue.Position);
end;
// -----------------------------------------------------------------------
procedure TForm1.Timer1Timer(Sender: TObject);
begin
   if not Assigned(Scope) then Exit;
   if CheckBox1.Checked
   then Scope.Value := trbarValue.Position * (1 + (0.1 * random - 0.05))
   else Scope.Value := trbarValue.Position;
   stxtValue.Caption := IntToStr(trbarValue.Position);
end;
// -----------------------------------------------------------------------
procedure TForm1.trbarNumLPFChange(Sender: TObject);
begin
    if not Assigned(Scope) then Exit;
    Scope.NumLPF := trbarNumLPF.Position;
    ftxtNumLPF.Caption := IntToStr(Scope.NumLPF);
end;
// -----------------------------------------------------------------------
//  
procedure TForm1.bttStyleClick(Sender: TObject);
begin
   if not Assigned(Scope) then Exit;
   if Scope.ScopeStyle = ssArc
   then Scope.ScopeStyle := ssPie
   else Scope.ScopeStyle := ssArc;
end;
// -----------------------------------------------------------------------
//    Image1
procedure TForm1.bttVisibleClick(Sender: TObject);
begin
    if not Assigned(Scope) then Exit;
    Scope.Visible := not Scope.Visible;
end;
// -----------------------------------------------------------------------
//  
procedure TForm1.bttCompactClick(Sender: TObject);
begin
    if not Assigned(Scope) then Exit;
    Scope.Compact := not Scope.Compact;
    Scope.ShowScope;
end;
// -----------------------------------------------------------------------
//  
procedure TForm1.bttTransporentClick(Sender: TObject);
begin
    if not Assigned(Scope) then Exit;
    Scope.Transparent := not Scope.Transparent;
end;
// -----------------------------------------------------------------------
//  
procedure TForm1.edNameChange(Sender: TObject);
begin
    if not Assigned(Scope) then Exit;
    Scope.ScopeName := edName.Text;
end;
// -----------------------------------------------------------------------
//    
procedure TForm1.CbBoxWallClick(Sender: TObject);
begin
    if not Assigned(Scope) then Exit;
    case CbBoxWall.ItemIndex of
    0 : Scope.WallStyle := wsNotUse;  //  
    1 : Scope.WallStyle := wsDam;     //    
    2 : Scope.WallStyle := wsLimit;   //    
    end;
end;
// =======================================================================
//      
// =======================================================================
//     
var flgPaint : Boolean;
    flgXOR   : Boolean;
    wXBeg, wYBeg  : Integer;
// -----------------------------------------------------------------------
//   
procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if not Assigned(Scope) then Exit;
  Scope.Visible := False;
  flgPaint := True;
  wXBeg := X;
  wYBeg := Y;
  Image1.Canvas.Pen.Style := psDot;
  Image1.Canvas.Pen.Mode  := pmNotXor;
  flgXOR := False;
end;
// -----------------------------------------------------------------------
//  
procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if not Assigned(Scope) then Exit;
  if not flgPaint then Exit;
  if (Abs(wXBeg - X) > 0) or (Abs(wYBeg - Y) > 0)
  then begin
    with Image1.Canvas do
    begin
       if flgXOR
       then Rectangle(wXBeg, wYBeg,
                      wXBeg + Scope.ScopeWidth, wYBeg + Scope.ScopeHeight);
       wXBeg := X;
       wYBeg := Y;
       Rectangle(wXBeg, wYBeg,
                 wXBeg + Scope.ScopeWidth, wYBeg + Scope.ScopeHeight);
       flgXOR := True;
       stxtXBeg.Caption := IntToStr(wXBeg);
       stxtYBeg.Caption := IntToStr(wYBeg);
    end;
  end;
end;
// -----------------------------------------------------------------------
//   
procedure TForm1.Image1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if not Assigned(Scope) then Exit;
  flgPaint := False;
  with Image1.Canvas do
  begin
    if flgXOR
    then Rectangle(wXBeg, wYBeg,
                   wXBeg + Scope.ScopeWidth, wYBeg + Scope.ScopeHeight);
    flgXOR := False;
    Pen.Mode := pmCopy;
  end;
  //  XBeg  YBeg  
  Scope.ScopePosition(wXBeg, wYBeg);
  Scope.Visible := True;
end;
// =======================================================================
//     
// =======================================================================
// -----------------------------------------------------------------------
//       
procedure TForm1.bttSetClick(Sender: TObject);
var wValue : extended;
begin
  if not Assigned(Scope) then Exit;
  //     
  if not TryEditToExt(edSet, wValue) then Exit;
  //  
  case CbBoxSet.ItemIndex of
  0 :  begin
          Scope.MinScope := wValue;    //   
          trbarValue.Min := Round(1.1 * wValue);
       end;
  1 :  Scope.M2Wall   := wValue;       //   
  2 :  Scope.M1Wall   := wValue;       //   
  3 :  begin
          Scope.MaxScope := wValue;    //   
          trbarValue.Max := Round(1.1 * wValue);
       end;
  4 :  Scope.P2Wall   := wValue;       //   
  5 :  Scope.P1Wall   := wValue;       //   
  end;
  //      
  ShowEdSet();
end;
// -----------------------------------------------------------------------
procedure TForm1.CbBoxSetClick(Sender: TObject);
begin
  //      
  ShowEdSet();
end;

// =======================================================================
// =======================================================================



end.
