unit DnPillars03;
// ====================================================================
(*
                      TDnPillars
                 

       
       .

        .
       TDnPillars   
         
   .
   // -----------------------------------------------------
    3.5. ()  , , , 2019..2021 .
               () Source code  ..
     20.03.2021
*)
// ====================================================================
interface

uses Windows, Messages, Classes, Controls, SysUtils, Graphics, Dialogs,
     Forms, StdCtrls, ExtCtrls, Menus;

// ====================================================================
//         
// ====================================================================

type TArrValue = array of extended;


// ====================================================================
//                TAsynchBeep
//          
// ====================================================================
// 23.02.2020
type TAsynchBeep = class(TThread)
private
   fFreq     : DWord;    //   
   fDuration : DWord;    //   
   fPause    : DWord;    //   
protected
   procedure Execute; override;
public
  property Freq     : DWord read fFreq write fFreq;
  property Duration : DWord read fDuration write fDuration;
  property Pause    : DWord read fPause write fPause;
end;

// ====================================================================
//                TDnPillars
// ====================================================================

type TTestMode = (tstNotUse,     //  
                  tstDam,        //  
                  tstLimit);     //  

type TDnPillars = class(TObject)
private
   // ==========================
   //    
   // ==========================
   // --------------------------
   fDFRM        : TForm;         //  
   // --------------------------
   fPanel       : TPanel;        //  
   fPanelCreate : boolean;       //  :    
   // --------------------------
   fImg         : TImage;        //  
   fBMP         : TBitMap;       //  
   fPM          : TPopupMenu;    // PopUpMenu
   // --------------------------
   fLbT         : TLabel;        // Label  
   fLbV         : TLabel;        // Label  
   // --------------------------
   fTimer       : TTimer;        //     ReSize
   // --------------------------
   fAsynchBeep  : TAsynchBeep;   //  Beep
   // ==========================
   //    
   // ==========================
   //   
   // --------------------------
   //   (   )
   fArea1L : integer;
   fArea1T : integer;
   fArea1H : integer;
   fArea1W : integer;
   // --------------------
   //   ( )
   fArea2L : integer;
   fArea2T : integer;
   fArea2H : integer;
   fArea2W : integer;
   // --------------------
   //    ( Y)
   fArea3L : integer;
   fArea3T : integer;
   fArea3H : integer;
   fArea3W : integer;
   // --------------------
   //    ( )
   fArea4L : integer;
   fArea4T : integer;
   fArea4H : integer;
   fArea4W : integer;
   fArea4D : integer;
   // --------------------------
   //  
   fFonColor    : TColor;         //   
   fTxtColor    : TColor;         //   
   fOkColor     : Tcolor;         //    
   fA1Color     : TColor;         //   
   fA2Color     : TColor;         //   
   // --------------------------
   fTitle       : string;         //  
   fYMes        : string;         //   
   // --------------------------
   //  
   fYMax        : extended;       //   
   // --------------------------
   //   
   fArrValue    : TArrValue;      //    
   fMaxIndx     : Integer;        //    fArrValue
   // --------------------------
   //     
   fP2Wall      : extended;       //      
   fP1Wall      : extended;       //     
   fTestMode    : TTestMode;      //    
   // --------------------------
   fSelect      : Integer;       //   
   // --------------------------
   //  
   fIndex       : Integer;       //   
   fValue       : extended;      //  
   fXLeft       : Integer;       // Pix - c  
   fVZone       : integer;       //   
   fVColor      : TColor;        //   
   // -----------
   fCountOK     : cardinal;      //   
   fCountY      : cardinal;      //     ALARM
   fCountR      : cardinal;      //    ALARM
   // -----------
   fRqGrid      : Boolean;       //   
   // ===========================
   //   
   // ===========================
   //     ""   
   procedure onDFRMClose(Sender: TObject; var Action: TCloseAction);
   //     Show
   procedure onDFRMShow(Sender: TObject);
   //     Hide
   procedure onDFRMHide(Sender: TObject);
   //   biSystemMenu : biMaximize
   procedure onDFRMActivate(Sender: TObject);
   //   biSystemMenu : biMinimize
   procedure onDFRMDeactivate(Sender: TObject);
   // --------------------------
   //    
   procedure CreateDynComponents();
   // --------------------------
   //  ReSize
   procedure onPanelReSize(Sender: TObject);
   //    ReSize
   procedure onReSizeTimer(Sender: TObject);
   //       
   procedure ReSize();
   // --------------------------
   //     PopupMenu
   procedure  GreateAndConnecPoUpMenu();
   //    PopupMenu
   procedure MenuClick(Sender : TObject);
   // ===========================
   //   
   // ===========================
   //    
   procedure CalcAreas();
   // --------------------------
   //    fBMP  fImg
   procedure BmpToImg ();
   //  fBMP
   procedure ImageClear(RqColor : TColor);
   // ==========================
   //  property
   // ==========================
   //    
   procedure SetTitle(RqTitle : string);
   //       
   procedure SetTestMode(RqMode : TTestMode);
   //    
   procedure SetYMax (RqYMax : extended);
   //      
   procedure SetP2Wall (RqP2Wall  : extended);
   //     
   procedure SetP1Wall (RqP1Wall  : extended);
   //     
   procedure VerifyWalls ();
   // --------------------------
   //    
   procedure  SetArrValue(RqArrValue : TArrValue);
   // ==========================
   //  
   procedure ShowTitle();
   // --------------------------
   //  
   procedure ClearCounters();
   //  ALARM - 
   procedure IncZoneCount(RqZone : integer);
   // --------------------------
   //     
   function ValueToZone(RqValue : extended) : integer;
   //     
   function ZoneToColor(RqZone : integer) : TColor;
   // --------------------------
   //   MouseDown ( "  ")
   procedure MouseDown(Sender: TObject; Button: TMouseButton;
                       Shift: TShiftState; X, Y: Integer);
   // --------------------------
   //  Y -   
   function CalcY(RqData : extended) : integer;
   //   
   procedure DrawCurrPillar();
   //   
   procedure DrawZoneLines();
   //   
   procedure DrawAllPillar();
   //  ALARM - 
   procedure ShowAlarmCounters();
   //     
   procedure ShowSelectScope();
   //   
   procedure ShowAxesY();
   //------------------------------

public
   // -----------------------------
   //   Pillars -    
   constructor Create(RqWidth, RqHeight : integer); overload;
   //   Pillars -    
   constructor Create(RqPanel : TPanel); overload;
   //   Pillars - 
   procedure   Free;
   // -----------------------------
   // 
   procedure Clear();
   //     fBMP     fImg
   procedure ShowReport();
   // -----------------------------
   //  
   property Title      : string    read fTitle    write SetTitle;
   // --------------------------
   //   
   property YMes     : string    read fYMes       write fYMes;
   //      
   property P2Wall    : extended    read fP2Wall  write SetP2Wall;
   //     
   property P1Wall    : extended    read fP1Wall  write SetP1Wall;
   //    
   property YMax      : extended    read fYMax    write SetYMax;
   //      
   property TestMode  : TTestMode read fTestMode  write SetTestMode;
   // --------------------------
   //    
   property ArrValue  : TArrValue read fArrValue  write SetArrValue;
   // --------------------------
   //  
   property FonColor  : TColor    read fFonColor  write fFonColor;
   //   
   property TxtColor  : TColor    read fTxtColor  write fTxtColor;
   // --------------------------
   //    
   property OkColor : TColor      read fOkColor   write fOkColor;
   //    
   property A1Color : TColor      read fA1Color   write fA1Color;
   //    
   property A2Color  : TColor     read fA2Color   write fA2Color;
   // --------------------------
   property RqGrid   : boolean    read fRqGrid    write fRqGrid;

end;

// ====================================================================
// ====================================================================
implementation
// ====================================================================
// ====================================================================


// ====================================================================
//                AsynchBeep
//                
// ====================================================================
// 23.02.2020
procedure TAsynchBeep.Execute();
begin
   while not Terminated
   do begin
     Windows.Beep(fFreq, fDuration);
     Sleep(fPause);
     Suspend;
   end;
end;
// ====================================================================
//                TDnPillars
//               
// ====================================================================
const TimeReSizeOut = 400;      //     ReSize

// ====================================================================
// --------------------------------------------------------------------
//    
// --------------------------------------------------------------------
const DFRM_MinW   = 380;        // .   
      DFRM_MinH   = 300;        // .   
      MinPanelW   = DFRM_MinW;  // .   
      MinPanelH   = DFRM_MinH;  // .   
      TopAreaH    = 20;         //    fImg
      DownAreaH   = 20;         //    fImg
      ImgBordX    = 2;          //  fImg     
// --------------------------------------------------------------------
//      fBMP
//  :
//   L - Left
//   T - Top
//   H - Height
//   W - Width
// --------------------------------------------------------------------
const BrdX   = 8;                  //   X
      BrdY   = 4;                  //   Y
      LineH = 16;                  //    
      AddH  = 8;                   //   
      // --------------------
      //   (   )
      Area1L = BrdX;
      Area1T = BrdY;
      Area1H = 3 * LineH + AddH;
      // --------------------
      //   ( )
      Area2L = BrdX;
      Area2H = 2 * LineH;
      // --------------------
      //    ( Y)
      Area3L = BrdX;
      Area3T = BrdY + Area1H;
      Area3W = 64;
      GrdNum = 10;
      // --------------------
      //    ( )
      Area4L = BrdX + Area3W;
      Area4T = Area3T;
      // --------------------
      PillarS = 16;               //    
      PillarW = PillarS div 2;    //  
      // --------------------
      InfoLen = 200;
      XBCount = Area1L + Area3W div 2;
      XECount = XBCount + InfoLen;
      XBScope = XECount;
      XEScope = XBScope + InfoLen;
      
// ====================================================================
//   / 
// ====================================================================
// --------------------------------------------------------------------
//     (OVERLOAD)
constructor TDnPillars.Create(RqWidth, RqHeight : integer);
begin
   inherited Create;
   // -----------------------------------
   //    
   fDFRM := TForm.Create(nil);
   with fDFRM do
   begin
      BorderIcons := [biSystemMenu,biMinimize,biMaximize];
      // -------------------
      onClose   := onDFRMClose;
      onShow    := onDFRMShow;
      onHide    := onDFRMHide;
      onActivate   := onDFRMActivate;
      onDeactivate := onDFRMDeActivate;
      // -------------------
      Caption   := ' Pillars -   3.0. ';
      Position  := poDesktopCenter;
      FormStyle :=  fsStayOnTop;
      AutoSize  := False;
      if RqWidth < DFRM_MinW
      then  ClientWidth := DFRM_MinW
      else  ClientWidth := RqWidth;
      if RqHeight < DFRM_MinH
      then  ClientHeight := DFRM_MinH
      else  ClientHeight := RqHeight;
      Constraints.MinWidth  := DFRM_MinW;
      Constraints.MinHeight := DFRM_MinH;

   end;
   // -----------------------------
   fPanel := TPanel.Create(fDFRM);
   fPanel.Parent := fDFRM;
   fPanel.SetBounds(0,0, fDFRM.ClientWidth, fDFRM.ClientHeight);
   fPanel.Align := alClient;
   //  :    
   fPanelCreate := True;
   // -----------------------------
   //    
   CreateDynComponents();
   // -----------------------------
   fDFRM.Show;
end;
// --------------------------------------------------------------------
//     (OVERLOAD)
constructor TDnPillars.Create(RqPanel : TPanel);
begin
   inherited Create;
   // -----------------------------
   fPanelCreate := False;  //  :    
   fPanel := RqPanel;
   //    
   fPanel.Constraints.MinHeight  := MinPanelH;
   fPanel.Constraints.MinWidth   := MinPanelW;
   //    ReSize
   fPanel.Anchors := [akLeft,akTop,akRight,akBottom];
   // -----------------------------
   //    
   CreateDynComponents();
   // -----------------------------
end;
// =================================================================
//    
// =================================================================
// -----------------------------------------------------------------
//    
procedure TDnPillars.CreateDynComponents();
begin
   // -----------------------------
   //  Image
   fImg  := TImage.Create(fPanel);
   fImg.Parent := fPanel;
   fImg.SetBounds(ImgBordX,TopAreaH,
                  fPanel.Width - 2 * ImgBordX,
                  fPanel.Height - TopAreaH - DownAreaH);
   fImg.OnMouseDown := MouseDown;
   // -----------------------------
   //     PopupMenu
   GreateAndConnecPoUpMenu();
   // -----------------------------
   //   
   fBMP := TBitMap.Create;
   fBMP.PixelFormat := pf24bit;
   fBMP.Height := fImg.Height;
   fBMP.Width  := fImg.Width;
   fBMP.Canvas.Font.Name := 'Tahoma';
   fBMP.Canvas.Font.Size := 8;
   // -----------------------------
   //  Label   
   fLbV := TLabel.Create(fPanel);
   fLbV.Parent := fPanel;
   fLbV.SetBounds(2,fPanel.Height-18,fPanel.Width-4,16);
   fLbV.AutoSize := True;
   fLbV.Font.Color := clBlack;
   // -----------------------------
   //  Label  
   fLbT := TLabel.Create(fPanel);
   fLbT.Parent := fPanel;
   fLbT.SetBounds(2,3,fPanel.Width-4,16);
   fLbT.AutoSize := True;
   fLbT.Font.Color := clBlack;
   // -----------------------------
   //     ReSize
   fTimer := TTimer.Create(nil);
   fTimer.Enabled := False;
   fTimer.onTimer := onReSizeTimer;
   //  OnResize   
   fPanel.OnResize := onPanelResize;
   // -----------------------------
   //  
   fP2Wall      := 0;              //    1
   fP1Wall      := 0;              //    2
   fA1Color     := clYellow;       //     
   fA2Color     := clRed;          //     
   fTestMode    := tstNotUse;      //    
   fLbV.Caption := '    ';
   // -----------------------------
   //    
   fFonColor    := clBlack;
   fTxtColor    := clWhite;
   fOkColor     := clLime;
   // -----------------------------
   fSelect      := -1;             //   
   // -----------------------------
   //  
   fTitle       := '    ';
   // -----------------------------
   fAsynchBeep  := TAsynchBeep.Create(True);
   with fAsynchBeep do
   begin
      FreeOnTerminate := True;
      fFreq := 440;
      fDuration := 100;
      fPause := 50;
   end;
   fRqGrid      := False;         //   
   //  
   ImageClear(fFonColor);
end;
// --------------------------------------------------------------------
//  
procedure TDnPillars.Free;
begin
   // ---------------------------------
   if Assigned(fTimer) then fTimer.Free;
   // ---------------------------------
   if Assigned(fPM)      then fPM.Free;
   if Assigned(fLbV)     then fLbV.Free;
   if Assigned(fLbT)     then fLbT.Free;
   if Assigned(fBMP)
   then begin
      fBMP.Free;
      fBMP := nil;
   end;
   if Assigned(fImg)    then fImg.Free;
   //  :    
   if fPanelCreate and Assigned(fPanel)
   then fPanel.Free;
   // ---------------------------------
   if Assigned(fDFRM)   then  fDFRM.Free;
   // ---------------------------------
   if Assigned(fAsynchBeep) then fAsynchBeep.Terminate;
   Sleep(20);
   // ---------------------------------
   inherited Free;
end;
// =================================================================
//      
// =================================================================
// -----------------------------------------------------------------
//    (   )   
procedure TDnPillars.onDFRMClose(Sender: TObject; var Action: TCloseAction);
// TCloseAction = (caNone, caHide, caFree, caMinimize);
begin
   Action := caMinimize;
end;
//     Show
procedure TDnPillars.onDFRMShow(Sender: TObject);
begin
end;
//     Hide
procedure TDnPillars.onDFRMHide(Sender: TObject);
begin
end;
//   biSystemMenu :biMaximize
procedure TDnPillars.onDFRMActivate(Sender: TObject);
begin
  //  
  fDFRM.FormStyle := fsStayOnTop;
end;
//   biSystemMenu : biMinimize
procedure TDnPillars.onDFRMDeactivate(Sender: TObject);
begin
end;
// ====================================================================
//  ReSize
// ====================================================================
procedure TDnPillars.onPanelResize(Sender: TObject);
begin
   if fImg.Visible
   then begin
       fLbT.Visible := False;
       fLbV.Visible := False;
       fImg.Visible := False;
       fTimer.Enabled := True;
   end;
   fTimer.Interval := TimeReSizeOut;
end;
// --------------------------------------------------------------------
procedure TDnPillars.onReSizeTimer(Sender: TObject);
begin
   fTimer.Enabled := False;
   ReSize;
end;
// --------------------------------------------------------------------
//      
procedure TDnPillars.ReSize();
begin
   with fImg do
   begin
      Picture.Bitmap.Width  := fPanel.Width  - 2 * ImgBordX;
      Picture.Bitmap.Height := fPanel.Height - TopAreaH - DownAreaH;
      fBMP.Width  :=  Picture.Bitmap.Width;
      fBMP.Height :=  Picture.Bitmap.Height;
      Width  :=  Picture.Bitmap.Width;
      Height :=  Picture.Bitmap.Height;
   end;
   fLbV.SetBounds(2,fPanel.Height-18,fPanel.Width-4,16);
   ShowReport();
   fImg.Visible := True;
   fLbV.Visible := True;
   fLbT.Visible := True;
end;
// ==================================================================
//    
// ==================================================================
// ------------------------------------------------------------------
// 20.03.2021
//     PopupMenu
procedure  TDnPillars.GreateAndConnecPoUpMenu();
var MenuItems : array of TMenuItem;
begin
   // =================================
   //    (PopupMenu)
   // =================================
   SetLength(MenuItems, 3);
   // --------------------
   MenuItems[0]:= NewItem(' ', TextToShortCut(''),
                          True, True, MenuClick, 0, 'M_NotUse');
   MenuItems[0].Tag := 1;
   MenuItems[0].RadioItem := True;
   // --------------------
   MenuItems[1]:= NewItem(' ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_Dam');
   MenuItems[1].Tag := 2;
   // --------------------
   MenuItems[2]:= NewItem(' ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_Limit');
   MenuItems[2].Tag := 3;
   // =================================
   //    (PopupMenu)
   fPM := NewPopupMenu(fImg, 'Menu',
                       paLeft, True, MenuItems);
   fImg.PopupMenu := fPM;
   // =================================
   SetLength(MenuItems,0);
end;
// --------------------------------------------------------------------
// 20.03.2021
procedure ResetRadioItem(RqMenu : TPopupMenu;  RqItem : TMenuItem);
var Ind : integer;
begin
   with RqMenu.Items do
   begin
     for Ind :=0 to Count - 1
     do begin
        Items[Ind].RadioItem := False;
        Items[Ind].Checked   := False;
     end;
     RqItem.RadioItem := True;
     RqItem.Checked   := True;
   end;
end;
// --------------------------------------------------------------------
// 20.03.2021
//    
procedure TDnPillars.MenuClick(Sender : TObject);
var Item  : TMenuItem;
begin
   Item :=  TMenuItem(Sender);
   case Item.Tag of
   1  :  begin //  
           ResetRadioItem(fPM, Item);
           Item.Checked := True;
           fTestMode := tstNotUse;
           ShowReport();
           fLbV.Caption := '    ';
         end;
   2  :  begin  //  
           ResetRadioItem(fPM, Item);
           Item.Checked := True;
           fTestMode := tstDam;
           ShowReport();
           fLbV.Caption := '    ';
         end;
   3  :  begin  //  
           ResetRadioItem(fPM, Item);
           Item.Checked := True;
           fTestMode := tstLimit;
           ShowReport();
           fLbV.Caption := '    ';
         end;
    end;
end;
// ====================================================================
//     
//     
// ====================================================================
// --------------------------------------------------------------------
// 20.03.2021
//    
procedure TDnPillars.CalcAreas();
var BmpH, BmpW, AreasW : Integer;
begin
     BmpH     := fBMP.Height;
     BmpW     := fBMP.Width;
     AreasW   := BmpW - 2 * BrdX;
     // --------------------
     fArea1L := Area1L;
     fArea1T := Area1T;
     fArea1H := Area1H;
     fArea1W := AreasW;
     // --------------------
     fArea2L := Area1L;
     fArea2T := BmpH - BrdY - Area2H;
     fArea2H := Area2H;
     fArea2W := AreasW;
     // --------------------
     fArea3L := Area3L;
     fArea3T := Area3T;
     fArea3H := BmpH - 2 * BrdY  - Area1H - Area2H;
     fArea3W := Area3W;
     // --------------------
     fArea4L := Area3L  + Area3W;
     fArea4T := Area3T;
     fArea4H := fArea3H;
     fArea4W := AreasW  - Area3W;
     fArea4D := fArea4T + fArea4H;
end;
// --------------------------------------------------------------------
// 20.03.2021
//     fImg
procedure TDnPillars.BmpToImg ();
var wImgRect : TRect;
begin
  if (not Assigned(fImg)) or (not Assigned(fBMP)) then Exit;
  //     fImg
  wImgRect := Rect(0, 0, fImg.Width, fImg.Height);
  fImg.Canvas.CopyRect(wImgRect,fBMP.Canvas,wImgRect);
end;
// --------------------------------------------------------------------
// 20.03.2021
//    
procedure TDnPillars.ImageClear(RqColor : TColor);
begin
  with fBMP.Canvas do
  begin
    Brush.Color := RqColor;
    Brush.Style := bsSolid;
    FillRect(Rect(0,0, fBMP.Width, fBMP.Height));
  end;
  //     fImg
  BmpToImg ();
end;
// ====================================================================
//  PROPERTY
// ====================================================================
// --------------------------------------------------------------------
// 20.03.2021
//  
procedure TDnPillars.SetTitle(RqTitle : string);
begin
   if Assigned(fLbT)
   then begin
       fTitle := '  ' + RqTitle;
       fLbT.Caption := fTitle;
       ShowTitle(); //  
   end;
end;
// --------------------------------------------------------------------
// 20.03.2021
//       
procedure  TDnPillars.SetTestMode(RqMode : TTestMode);
begin
  fTestMode := RqMode;
  ShowReport();
end;
// --------------------------------------------------------------------
// 20.03.2021
//    
procedure TDnPillars.SetYMax (RqYMax : extended);
begin
   fYMax := RqYMax;
end;
// --------------------------------------------------------------------
// 20.03.2021
//  () 
procedure TDnPillars.SetP2Wall (RqP2Wall : extended);
begin
  fP2Wall := Abs(RqP2Wall);
end;
// --------------------------------------------------------------------
// 20.03.2021
//  () 
procedure TDnPillars.SetP1Wall (RqP1Wall : extended);
begin
  fP1Wall := Abs(RqP1Wall);
end;
// --------------------------------------------------------------------
// 20.03.2021
//     
procedure TDnPillars.VerifyWalls ();
begin
   //      ( )
   if (fP2Wall = 0)
   then begin
      fP1Wall := 0;
      //       " "
      fTestMode := tstNotUse;
      ResetRadioItem(fPM, fPM.Items[0]);
      fLbV.Caption := '    ';
      Exit;
   end;
   //      
   if (fP2Wall > Abs(fYMax))then fP2Wall := Abs(fYMax);
   //     ,    
   if (fP1Wall > fP2Wall)
   then begin
      fP1Wall := fP2Wall;
      Exit;
   end;
end;
// --------------------------------------------------------------------
// 20.03.2021
//    
procedure  TDnPillars.SetArrValue(RqArrValue : TArrValue);
begin
   if Length(RqArrValue) > 0
   then begin
       fArrValue := RqArrValue;
       fMaxIndx  := High(fArrValue);
   end;
end;
// ====================================================================
// --------------------------------------------------------------------
// 20.03.2021
//  
procedure TDnPillars.ShowTitle();
begin
  if not Assigned(fLbT) then Exit;
  fLbT.Caption := fTitle;
end;
// --------------------------------------------------------------------
// 20.03.2021
//  
procedure TDnPillars.ClearCounters();
begin
   fCountOK  := 0;      //   
   fCountY   := 0;      //     ALARM
   fCountR   := 0;      //    ALARM
end;
// --------------------------------------------------------------------
// 20.03.2021
//  ALARM - 
procedure TDnPillars.IncZoneCount(RqZone : integer);
begin
   case fTestMode of
      tstNotUse :     //  
               Inc(fCountOK);      //   
      tstDam    :                  //  
         case RqZone of
           1 : Inc(fCountOK);      //   
           2 : Inc(fCountY);       //     ALARM
           3 : Inc(fCountR);       //    ALARM
         end;
      tstLimit    :   //  
         case RqZone of
           1 : Inc(fCountR);       //    ALARM
           2 : Inc(fCountOK);      //   
           3 : Inc(fCountR);       //    ALARM
         end;
   end;
end;
// --------------------------------------------------------------------
// 20.03.2021
//     
function TDnPillars.ValueToZone(RqValue : extended) : integer;
begin
   if RqValue > 0
   then begin
       if (RqValue > 0)  and (RqValue < fP1Wall)
       then begin
           Result := 1;  Exit;
       end;
       if (RqValue >= fP1Wall) and (RqValue < fP2Wall)
       then begin
           Result := 2;  Exit;
       end;
       if (RqValue >= fP2Wall)
       then begin
           Result := 3;  Exit;
       end;
   end;
   Result := 0;
end;
// --------------------------------------------------------------------
// 20.03.2021
//     
function TDnPillars.ZoneToColor(RqZone : integer) : TColor;
begin
   Result := fFonColor;
   case fTestMode of
      tstNotUse :   //  
         case RqZone of
           0  : Result := fFonColor;
           else Result := fOkColor;     //    
         end;
      tstDam    :   //  
         case RqZone of
           0 : Result := fFonColor;
           1 : Result := fOkColor;      //    
           2 : Result := fA1Color;      //   
           3 : Result := fA2Color;      //   
         end;
      tstLimit    :   //  
         case RqZone of
           0 : Result :=  fA2Color;      //   
           1 : Result :=  fA2Color;      //   
           2 : Result :=  fOkColor;      //    
           3 : Result :=  fA2Color;      //   
         end;
   end;
end;
// --------------------------------------------------------------------
// --------------------------------------------------------------------
// 20.03.2021
//     
procedure TDnPillars.ShowSelectScope();
const Text1 = '  : ';
      Text2 = '  : ';
var XL, YT, YTxt  : integer;
begin
  if fSelect < 0 then Exit;
  with fBMP.Canvas do
  begin
      Brush.Style := bsSolid;
      // --------------------
      //    
      XL := fArea4L + fSelect * PillarS;
      YT := fArea2T + LineH;
      //     
      Brush.Color := fFonColor;
      FillRect(Rect(fArea4L, YT, fArea4L + fArea4W, YT + PillarW));
      //    
      Brush.Color := clAqua;
      FillRect(Rect(XL, YT, XL + PillarW, YT + PillarW));
      // --------------------
      //     
      Brush.Color := fFonColor;
      FillRect(Rect(XBScope, fArea1T, XEScope, fArea1T + fArea1H - AddH));
      if fSelect  < 0 then Exit;
      //   
      XL   := XBScope;
      YT   := fArea1T + 4;
      YTxt := fArea1T + 2;
      //  
      Brush.Color := clAqua;
      FillRect(Rect( XL, YT,  XL + PillarW, YT + PillarW));
      Brush.Style := bsClear;
      TextOut( XL + PillarS, YTxt, Text1 + IntToStr(fSelect));
      //   
      YT   := YT   + LineH;
      YTxt := YTxt + LineH;
      //   
      fIndex  := fSelect;                  //   
      fValue  := fArrValue[fIndex];    //  
      fVZone  := ValueToZone(Abs(fValue));      //   
      fVColor := ZoneToColor(fVZone);      //   
      //  
      Brush.Color := fVColor;
      FillRect(Rect( XL, YT,  XL + PillarW, YT + PillarW));
      Brush.Style := bsClear;
      TextOut( XL + PillarS, YTxt, Text2 + FloatToStr(fValue) + ' ' + fYMes);
      // --------------------
   end;
end;
// --------------------------------------------------------------------
// 20.03.2021
//  ALARM - 
procedure TDnPillars.ShowAlarmCounters();
const Text1 = '  : ';
var XL, YT, YTxt  : integer;
begin
  with fBMP.Canvas do
  begin
      //    
      Brush.Style := bsSolid;
      Brush.Color := fFonColor;
      FillRect(Rect(XBCount, fArea1T, XECount, fArea1T + fArea1H - AddH));
      //   
      XL   := XBCount;
      YT   := fArea1T + 4;
      YTxt := fArea1T + 2;
      if fCountOK > 0
      then begin
        Brush.Color := fOkColor;
        FillRect(Rect( XL, YT,  XL + PillarW, YT + PillarW));
        Brush.Style := bsClear;
        TextOut( XL + PillarS, YTxt, Text1 + IntToStr(fCountOK));
      end;
      if fCountY > 0
      then begin
        YT   := YT   + LineH;
        YTxt := YTxt + LineH;
        Brush.Color := fA1Color;
        FillRect(Rect( XL, YT,  XL + PillarW, YT + PillarW));
        Brush.Style := bsClear;
        TextOut( XL + PillarS, YTxt, Text1 + IntToStr(fCountY));
      end;
       if fCountR > 0
      then begin
        YT   := YT   + LineH;
        YTxt := YTxt + LineH;
        Brush.Color := fA2Color;
        FillRect(Rect( XL, YT,  XL + PillarW, YT + PillarW));
        Brush.Style := bsClear;
        TextOut( XL + PillarS, YTxt, Text1 + IntToStr(fCountR));
      end;
   end;
end;
// --------------------------------------------------------------------
// --------------------------------------------------------------------
// 20.03.2021
//   MouseDown ( "  ")
procedure TDnPillars.MouseDown(Sender: TObject; Button: TMouseButton;
                               Shift: TShiftState; X, Y: Integer);
var Ind : integer;
begin
  if not (Button = mbLeft) then Exit;
  //   
  if (Y < fArea4T) or (Y > fArea4D + LineH) then Exit;
  Ind := Round((X - Area4L) / PillarS);
  //   
  if (Ind < 0) or (Ind > High(fArrValue)) then Exit;
  fSelect := Ind;
  //     
  ShowSelectScope();
  //   
  BmpToImg ();
end;
// --------------------------------------------------------------------
// --------------------------------------------------------------------
// 20.03.2021
//  Y -   
function TDnPillars.CalcY(RqData : extended) : integer;
begin
  if Abs(fYMax) < 1e-10
  then begin
     Result := fArea4D;
     Exit;
  end;
  try
     Result := fArea4D - Trunc((fArea4H / Abs(fYMax)) * RqData);
  except
     Result := fArea4D;
  end;
end;
// --------------------------------------------------------------------
// 20.03.2021
//   
procedure TDnPillars.DrawCurrPillar();
begin
   fXLeft := fArea4L + fIndex * PillarS;
   with fBMP.Canvas do
   begin
     //  
     Brush.Style := bsSolid;
     Brush.Color := fVColor;
     Pen.Color   := Brush.Color;
     Rectangle(fXLeft, fArea4D, fXLeft + PillarW, CalcY(Abs(fValue)));
     //   
     Font.Color  := RGB(255,255,255);
     Brush.Style := bsClear;
     TextOut(fXLeft, fArea2T, IntToStr(fIndex));
   end;
end;
// --------------------------------------------------------------------
// 20.03.2021
//   
procedure TDnPillars.DrawAllPillar();
var Index : Integer;
begin
  CalcAreas();
  for Index := Low(fArrValue) to High(fArrValue)
  do begin
    //  
     fIndex  := Index;                     //   
     fValue  := fArrValue[Index];          //  
     fVZone  := ValueToZone(Abs(fValue));  //   
     fVColor := ZoneToColor(fVZone);       //   
     //   
     DrawCurrPillar();
     //  ALARM - 
     IncZoneCount(fVZone);
  end;
  //   
  DrawZoneLines();
  //  ALARM - 
  ShowAlarmCounters();
  //   
  ShowSelectScope();
end;
// --------------------------------------------------------------------
// --------------------------------------------------------------------
// 20.03.2021
//   
procedure TDnPillars.DrawZoneLines();
var Color1, Color2 : TColor;
begin
   case fTestMode of
     tstDam   : begin
                   Color1 := fA1Color;
                   Color2 := fA2Color;
                end;
     tstLimit : begin
                   Color1 := fA2Color;
                   Color2 := fA2Color;
                end;
     else Exit;
   end;
   with fBMP.Canvas do
   begin
     //    
     Pen.Color := Color1;
     MoveTo(fArea4L,CalcY(fP1Wall));
     LineTo(fArea4L + (fMaxIndx + 1) * PillarS, CalcY(fP1Wall));
     //    
     Pen.Color := Color2;
     MoveTo(fArea4L,CalcY(fP2Wall));
     LineTo(fArea4L + (fMaxIndx + 1) * PillarS, CalcY(fP2Wall));
   end;
end;
// --------------------------------------------------------------------
// 20.03.2021
//   
procedure TDnPillars.ShowAxesY();
var YStep, Indx, YT  : Integer;
    VStep : Extended;
begin
   YStep := Round(fArea3H / (GrdNum));
   VStep := fYMax / GrdNum;
   with fBMP.Canvas do
   begin
      Pen.Color := fTxtColor;
      YT := fArea3T + fArea3H - (GrdNum) * YStep;
      MoveTo(fArea3L, YT);
      LineTo(fArea3L, fArea3T + fArea3H);

      for Indx := 0 to (GrdNum) do
      begin
         Pen.Color := fTxtColor;
         YT := fArea3T + fArea3H - Indx * YStep;
         MoveTo(fArea3L,      YT);
         LineTo(fArea3L  + 8, YT);
         TextOut(fArea3L + 12, YT - 4,  Format('%5.2f',[Indx * VStep]));
         //  ,   
         if fRqGrid
         then begin
            Pen.Color := clGray;
            MoveTo(fArea4L,      YT);
            LineTo(fArea4L + (fMaxIndx + 1) * PillarS, YT);
         end;
      end;
   end;
end;
// ====================================================================
//   
// ====================================================================
// --------------------------------------------------------------------
// 20.03.2021
//     fBMP     fImg
procedure TDnPillars.ShowReport();
begin
  if Length(fArrValue) < 1 then Exit;
  //    
  ShowTitle();
  //  
  ImageClear(fFonColor);
  //  
  ClearCounters();
  //     
  VerifyWalls ();
  //   
  DrawAllPillar();
  //   
  ShowAxesY();
  //     fImg
  BmpToImg ();
  //  - 
  if (fCountY > 0) or (fCountR > 0)
  then if Assigned(fAsynchBeep) then fAsynchBeep.Resume;
end;
// --------------------------------------------------------------------
// 20.03.2021
//  
procedure TDnPillars.Clear();
begin
   ShowTitle();             //  
   ClearCounters();         //  
   ImageClear(fFonColor);   //  
end;
// ====================================================================
// ====================================================================

end.
