unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls,
  DnDigits03;


type
  TForm1 = class(TForm)
    btn5: TButton;
    btn6: TButton;
    pnl1: TPanel;
    cbb1: TComboBox;
    chk1: TCheckBox;
    tmr1: TTimer;
    chk2: TCheckBox;
    cbb2: TComboBox;
    cbb3: TComboBox;
    lbl1: TLabel;
    lbl2: TLabel;
    lbl3: TLabel;
    procedure btn5Click(Sender: TObject);
    procedure btn6Click(Sender: TObject);
    procedure tmr1Timer(Sender: TObject);
    procedure cbb1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}



var Digits, DnDigits : TDnDigits;
    DValue : Integer;

// ===========================================================-
//    TForm1
// ===========================================================
// -----------------------------------------------------------
//  
procedure TForm1.btn5Click(Sender: TObject);
begin
    if (not Assigned(Digits)) and (not Assigned(DnDigits))
    then begin
      DnDigits := TDnDigits.Create();
      DnDigits.Title := '   ';
      DnDigits.YMes  := '.';
      DnDigits.Clear;
      // -------------------------------------
      Digits := TDnDigits.Create(pnl1);

      Digits.Title := '  ';
      Digits.YMes  := '.';
      Digits.Clear;
    end;
end;
//  
procedure TForm1.btn6Click(Sender: TObject);
begin
   if Assigned(Digits)
   then begin
      Digits.Free;
      Digits := nil;
   end;
   if Assigned(DnDigits)
   then begin
      DnDigits.Free;
      DnDigits := nil;
   end;
end;

procedure ShowDigit(RqDigit  : TDnDigits;
                    RqRadix, RqSCode, RqValue : integer);
var wRadix : TRadix;
begin
    //   
   case RqRadix of
     0 : wRadix := rdxDecimal;  //   
     1 : wRadix := rdxHex;      //   
     2 : wRadix := rdxBit;      //   
     else wRadix := rdxDecimal;
   end;
   case TSCode(RqSCode) of
      scdClear    : begin RqDigit.Clear; DValue := 0; end;
      scdText     : RqDigit.ShowTextValue(IntToStr(RqValue));
      scdBit      : RqDigit.ShowByteValue(wRadix, RqValue);
      scdWord     : RqDigit.ShowWordValue(wRadix, Abs(RqValue));
      scdLongWord : RqDigit.ShowLongWordValue(wRadix, Abs(RqValue));
      scdInteger  : RqDigit.ShowIntegerValue(wRadix, RqValue);
      scdInt64    : RqDigit.ShowInt64Value(wRadix, RqValue);
      scdExtended : RqDigit.ShowExtendedValue(RqValue + 0.1)
      else RqDigit.Clear;
   end;
end;

//  
procedure TForm1.tmr1Timer(Sender: TObject);
begin
   if not chk1.Checked then Exit;
   if chk2.Checked
   then Dec(DValue)
   else Inc(DValue);
   if Assigned(Digits) and  Assigned(DnDigits)
   then begin
      ShowDigit(Digits,   cbb2.ItemIndex, cbb3.ItemIndex, DValue);
      ShowDigit(DnDigits, cbb2.ItemIndex, cbb3.ItemIndex, DValue);
   end;
end;

//   
procedure TForm1.cbb1Click(Sender: TObject);
begin
  case  cbb1.ItemIndex of
    0 : tmr1.Interval := 1000;   // ms
    1 : tmr1.Interval := 5000;   // ms
    2 : tmr1.Interval := 10000;  // ms
    3 : tmr1.Interval := 50000;  // ms
  end;
end;



end.
