unit UnitCP1251ToDoc;

interface

uses Windows, Messages, SysUtils, Dialogs, Variants,
     Classes, Graphics, ComObj,
     TicketsTools;

//    MSWord
function ExistsMSWord() : boolean;

//   CP1251  MS Word
function CP1251ToDoc(
           // StringList  
           RqStringList   : TStringList;
           //   
           RqDestFileName : string) : boolean;

//   
var ConvertCancel    : boolean;

// =================================================================
// =================================================================
implementation
// =================================================================
// =================================================================

// -----------------------------------------------------------------
//    MS Word
function ExistsMSWord() : boolean;
var WO : Variant;
begin
   Result :=False;         // MS Word NOT present
   WO := UnAssigned;
   try
     //       MS WORD
     WO := CreateOleObject('Word.Application');
   except end;
   if not VarIsEmpty(WO)
   then begin
       Result := True;    // MS Word present
       //   WO  
       WO.Quit;
   end;
   if not Result
   then MessageDlg('   MS Word.'
        + #13#10 + '   '
        + #13#10 + '    ...',
         mtInformation, [mbOk], 0);
end;

// -----------------------------------------------------------------
//   CP1251  MS Word
function CP1251ToDoc(
           // StringList  
           RqStringList  : TStringList;
           //   
           RqDestFileName : string) : boolean;
// -----------------------
const wdFormatDocument = 0;
      BlankChar = ' ';
var
    wDestDir      : string;   //   
    fWO           : variant;  //  MS Word
    indx          : integer;  //  
    wStr          : string;   //    
    wCancelName   : string;   //     
begin
   Result := False;
   // --------------------------
   //  
   if RqStringList.Count <= 0 then Exit;
   if RqDestFileName = '' then Exit;
   if UpperCase(ExtractFileExt(RqDestFileName)) <> '.DOC' then Exit;
   wDestDir := ExtractFileDir(RqDestFileName);
   if not DirectoryExists(wDestDir) then Exit;
   // --------------------------
   //       MS WORD
   fWO := UnAssigned;
   try
     //      MS WORD
     fWO := CreateOleObject('Word.Application');
   except
     //   Word.Application 
     if VarIsEmpty(fWO) then  Exit;
   end;
   // --------------------------
   //    
   try
     //   doc -   
     fWO.Documents.Add();
   except
     //    doc -  
     if not VarIsEmpty(fWO)
     then begin
        //   fWO  
        fWO.Quit;
        fWO := UnAssigned;
     end;
     Exit;
   end;
   // --------------------------
   if Assigned(IndicatorCnv)
   then begin
      IndicatorCnv.Color := clSkyBlue;
      IndicatorCnv.NextStep := 5;
      IndicatorCnv.Clear;
   end;
   //  
   try
      //   
      for indx := 0 to RqStringList.Count - 1 do
      begin
        wStr := RqStringList.Strings[indx];
        if wStr = '' then wStr := wStr + BlankChar;
        try
          //    doc - 
          fWO.Selection.TypeText(Text:=wStr);
          fWO.Selection.TypeParagraph;
          if Assigned(IndicatorCnv) then IndicatorCnv.Next;

        except
           if not VarIsEmpty(fWO)
           then begin
              //   fWO  
              fWO.Quit;
              fWO := UnAssigned;
           end;
           Exit;
        end;
      end;
   except
      if not VarIsEmpty(fWO)
      then begin
         //   fWO  
         fWO.Quit;
         fWO := UnAssigned;
      end;
      Exit;
   end;
   // --------------------------
   //  
   if not ConvertCancel
   then begin
      try
         fWO.ActiveDocument.SaveAs(
             FileName:=RqDestFileName,
             FileFormat:=wdFormatDocument,
             LockComments:=False,
             Password:='',
             AddToRecentFiles:=True,
             WritePassword:='',
             ReadOnlyRecommended:=False,
             EmbedTrueTypeFonts:=False,
             SaveNativePictureFormat:=False,
             SaveFormsData:=False,
             SaveAsAOCELetter:=False);
         Result := True;
      except  end;
   end
   else begin
       //  
       wCancelName := wDestDir + '\LastCancelFile.doc';
       try
          fWO.ActiveDocument.SaveAs(
             FileName:=wCancelName,
             FileFormat:=wdFormatDocument,
             LockComments:=False,
             Password:='',
             AddToRecentFiles:=True,
             WritePassword:='',
             ReadOnlyRecommended:=False,
             EmbedTrueTypeFonts:=False,
             SaveNativePictureFormat:=False,
             SaveFormsData:=False,
             SaveAsAOCELetter:=False);
       except end;
   end;
   //   fWO  
   fWO.Quit;
   fWO := UnAssigned;
   if Assigned(IndicatorCnv) then IndicatorCnv.Clear;
   
end;

end.
