unit TicketsTools;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  StrUtils, ExtCtrls;

// ====================================================================
// TIndicator
//
//       
// .     TImage 
//      Next().
//      NextStep, 
//    Next()    . 
//  NextStep  100.
// ====================================================================
type TIndicator = class(TObject)
private
  fImg      : TImage;
  fFonColor : TColor;
  fColor    : TColor;
  fNextStep : Word;
  fCount    : integer;
  fX        : integer;
  fXE       : integer;
  fYE       : integer;
public
  constructor Create(RqImage : TImage);
  procedure Clear();
  procedure Next();
  property FonColor : TColor read fFonColor write fFonColor;
  property Color    : TColor read fColor write fColor;
  property NextStep : Word   read fNextStep write fNextStep;
end;

var IndicatorCnv    : TIndicator;

implementation

// ====================================================================
// TIndicator
// ====================================================================
// --------------------------------------------------------------------
constructor TIndicator.Create(RqImage : TImage);
begin
   inherited Create;
   fImg      := RqImage;
   fFonColor := clBtnFace;
   fColor    := RGB(100,255,100);
   fNextStep := 100;
   fXE       := fImg.Width;
   fYE       := fImg.Height;
   Clear();
end;
// --------------------------------------------------------------------
//  
procedure TIndicator.Clear();
begin
   fX      := 0;
   fCount  := 0;
   fImg.Canvas.Pen.Color := fColor;
   fImg.Canvas.Pen.Style := psSolid;
   fImg.Canvas.Brush.Color := fFonColor;
   fImg.Canvas.Brush.Style := bsSolid;
   fImg.Canvas.FillRect(Rect(0,0,fImg.Width, fImg.Height));
end;
// --------------------------------------------------------------------
procedure TIndicator.Next();
begin
   Inc(fCount);
   if fCount < fNextStep
   then Exit;
   with fImg.Canvas do
   begin
      MoveTo(fX, 0);
      LineTo(fX, fYE);
      Inc(fX);
      if fX > fXE
      then begin
          fX := 0;
          FillRect(Rect(0,0,fImg.Width, fImg.Height));
      end;
   end;
   fCount := 0;
   fImg.Repaint;
end;


end.
 