unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, TicketsTools, UnitCP1251ToDoc;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    Theme1: TTabSheet;
    Theme2: TTabSheet;
    Theme3: TTabSheet;
    Tickets: TTabSheet;
    sbtnLoad1: TSpeedButton;
    sbtnSave1: TSpeedButton;
    stxtLoad1: TStaticText;
    Label1: TLabel;
    Memo1: TMemo;
    Label2: TLabel;
    Label3: TLabel;
    sbtnLoad2: TSpeedButton;
    stxtLoad2: TStaticText;
    sbtnSave2: TSpeedButton;
    Memo2: TMemo;
    Label5: TLabel;
    sbtnLoad3: TSpeedButton;
    stxtLoad3: TStaticText;
    sbtnSave3: TSpeedButton;
    Memo3: TMemo;
    Memo4: TMemo;
    CmBoxQB1: TComboBox;
    CmBoxQB2: TComboBox;
    CmBoxQB3: TComboBox;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label11: TLabel;
    CmBoxTicketsNum: TComboBox;
    sbtnTickedsSave: TSpeedButton;
    sbtnRUN: TSpeedButton;
    stxtLoad1Num: TStaticText;
    Label12: TLabel;
    Label13: TLabel;
    stxtLoad2Num: TStaticText;
    Label14: TLabel;
    Label15: TLabel;
    stxtLoad3Num: TStaticText;
    Label16: TLabel;
    btnToWord: TSpeedButton;
    edtTicket: TEdit;
    lbl1: TLabel;
    procedure sbtnLoad1Click(Sender: TObject);
    procedure sbtnLoad2Click(Sender: TObject);
    procedure sbtnLoad3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure sbtnRUNClick(Sender: TObject);
    procedure sbtnSave1Click(Sender: TObject);
    procedure sbtnSave2Click(Sender: TObject);
    procedure sbtnSave3Click(Sender: TObject);
    procedure sbtnTickedsSaveClick(Sender: TObject);
    procedure btnToWordClick(Sender: TObject);
  private
    { Private declarations }
    procedure Generator();
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// -----------------------------------------------------------------
//  
// -----------------------------------------------------------------
var Lst1, Lst2, Lst3 : TStringList;

// -----------------------------------------------------------------
//       
// -----------------------------------------------------------------
// 20.11.2019
//          
// : FileName := ExtSaveDialog('.txt');
function ExtSaveDialog(RqTitle, RqExt : string) : string;
var Dialog  : TSaveDialog;
    FileExt : string;     //   
begin
  Result := '';
  Dialog  := TSaveDialog.Create(NIL);
  //  
  Dialog.Filter := RqTitle + ' (*'
                 + LowerCase(RqExt) + ')|*' + UpperCase(RqExt);
  //   
  if Dialog.Execute
  then begin
     Result := Dialog.FileName;
     FileExt  := UpperCase(ExtractFileExt(Result));
     //     ,    
     if not (FileExt = UpperCase(RqExt))
     then Result := Result + LowerCase(RqExt);
     //   
     if FileExists(Result)
     then begin
        if MessageDlg('   .'+ #13#10
                    + '   ?',
                       mtInformation,[mbYes,mbNo],0) = mrNo
        then Result := '';
     end;
  end;
  Dialog.Free;
end;

// -----------------------------------------------------------------
// 20.11.2019
//          
// : FileName := ExtOpenDialog('.txt');
function ExtOpenDialog(RqTitle, RqExt : string) : string;
var Dialog : TOpenDialog;
begin
  Result := '';
  Dialog := TOpenDialog.Create(NIL);
  //  
  Dialog.Filter := RqTitle + ' (*'
                   + LowerCase(RqExt) + ')|*' + UpperCase(RqExt);
  //   
  if Dialog.Execute
  then Result := Dialog.FileName;
  Dialog.Free;
end;

// -----------------------------------------------------------------
//    
// -----------------------------------------------------------------
//   
procedure LoadQuestsLst(RqMemo : TMemo; stxtFName, stxtQNum : TStaticText);
begin
    stxtQNum.Caption := '';
    stxtFName.Caption := ExtOpenDialog(' ', '.txt');
    if stxtFName.Caption <> ''
    then begin
       RqMemo.Lines.LoadFromFile(stxtFName.Caption);
       stxtQNum.Caption := IntToStr(RqMemo.Lines.Count);
    end;
end;
// -----------------------------------------------------------------
//     1
procedure TForm1.sbtnLoad1Click(Sender: TObject);
begin
    LoadQuestsLst(Memo1, stxtLoad1, stxtLoad1Num);
end;
// -----------------------------------------------------------------
//     2
procedure TForm1.sbtnLoad2Click(Sender: TObject);
begin
   LoadQuestsLst(Memo2, stxtLoad2, stxtLoad2Num);
end;
// -----------------------------------------------------------------
//     3
procedure TForm1.sbtnLoad3Click(Sender: TObject);
begin
   LoadQuestsLst(Memo3, stxtLoad3, stxtLoad3Num);
end;

// -----------------------------------------------------------------
//     
// -----------------------------------------------------------------
//     
procedure CopyLst (RqMemo : TMemo; RqLst : TStringList);
var Indx : integer;
begin
    RqLst.Clear;
    if RqMemo.Lines.Count < 1 then Exit;
    for Indx := 0 to RqMemo.Lines.Count - 1
    do begin
       if Trim(RqMemo.Lines.Strings[Indx]) <> ''
       then RqLst.Add(RqMemo.Lines.Strings[Indx]);
    end;
end;
// -----------------------------------------------------------------
 //   
function GetTicketsNum (RqCmBox : TComboBox) : integer;
begin
  case RqCmBox.ItemIndex of
   0 : Result := 10; // 
   1 : Result := 15; // 
   2 : Result := 20; // 
   3 : Result := 25; // 
   4 : Result := 30; // 
   5 : Result := 35; // 
   6 : Result := 40; // 
   7 : Result := 50; // 
   8 : Result := 60; // 
   else Result := 0;
  end;
end;
// -----------------------------------------------------------------
//    ,     
function GetBlockQuestNum (RqCmBox : TComboBox) : integer;
begin
   case RqCmBox.ItemIndex of
    0 : Result := 0;
    1 : Result := 1;
    2 : Result := 2;
    3 : Result := 3;
    else Result := 0;
  end;
end;
// -----------------------------------------------------------------
//       
function GetOneQuest(RqMemo : TMemo; RqLst : TStringList) : string;
var Rnd  : integer;
begin
    Result := '';
    if RqLst.Count > 0
    then begin
       //  Count = 1  random   0
       Rnd  := random(RqLst.Count);
       Result := RqLst.Strings[Rnd];
       RqLst.Delete(Rnd);
    end;
end;
// -----------------------------------------------------------------
//  
procedure TForm1.Generator();
var TicketsNum : integer;
    QBNum1, QBNum2, QBNum3 : integer;
    TIndx,  QIndx,  Num   :  integer;
    wStr  : string;
begin
  Randomize; 
  //   
  TicketsNum := GetTicketsNum(CmBoxTicketsNum);
  //    ,     
  QBNum1 := GetBlockQuestNum(CmBoxQB1);
  QBNum2 := GetBlockQuestNum(CmBoxQB2);
  QBNum3 := GetBlockQuestNum(CmBoxQB3);
  //   
  CopyLst(Memo1, Lst1);
  CopyLst(Memo2, Lst2);
  CopyLst(Memo3, Lst3);
  //  
  Memo4.Clear;
  for TIndx := 1 to TicketsNum
  do begin
     Num := 0;
     Memo4.Lines.Add(edtTicket.Text + ' ' + IntToStr(TIndx));
     //     
     if (QBNum1 > 0)
     then begin
        //      Lst1  
        // QBNum1    
        if (Lst1.Count < QBNum1 + 1) then CopyLst(Memo1, Lst1);
        //  
        for QIndx := 1 to QBNum1
        do begin
           wStr := GetOneQuest(Memo1, Lst1);
           if wStr <> ''
           then begin
             Inc(Num);
             Memo4.Lines.Add(' ' + IntToStr(Num)+ '. ' + wStr);
           end;
        end;
     end;
     //     
     if (QBNum2 > 0)
     then begin
        if (Lst2.Count < QBNum2 + 1) then CopyLst(Memo2, Lst2);
        for QIndx := 1 to QBNum2
        do begin
           wStr := GetOneQuest(Memo2, Lst2);
           if wStr <> ''
           then begin
             Inc(Num);
             Memo4.Lines.Add(' ' + IntToStr(Num)+ '. ' + wStr);
           end;
        end;
     end;
     //     
     if (QBNum3 > 0)
     then begin
        if (Lst3.Count < QBNum3 + 1) then CopyLst(Memo3, Lst3);
        for QIndx := 1 to QBNum3
        do begin
           wStr := GetOneQuest(Memo3, Lst3);
           if wStr <> ''
           then begin
             Inc(Num);
             Memo4.Lines.Add(' ' + IntToStr(Num)+ '. ' + wStr);
           end;
        end;
     end;
     Memo4.Lines.Add('');
  end;

end;
// -----------------------------------------------------------------
//   
procedure TForm1.sbtnRUNClick(Sender: TObject);
begin
    Generator();
end;

// -----------------------------------------------------------------
//      
// -----------------------------------------------------------------
//  
procedure SaveLst(RqMemo : TMemo);
var wFileName : string;
begin
    if RqMemo.Lines.Count < 2 then Exit;
    wFileName := ExtSaveDialog(' ', '.txt');
    if wFileName <> ''
    then RqMemo.Lines.SaveToFile(wFileName);
end;
// -----------------------------------------------------------------
//     2
procedure TForm1.sbtnSave1Click(Sender: TObject);
begin
   SaveLst(Memo1);
end;
// -----------------------------------------------------------------
//     2
procedure TForm1.sbtnSave2Click(Sender: TObject);
begin
   SaveLst(Memo2);
end;
// -----------------------------------------------------------------
//     3
procedure TForm1.sbtnSave3Click(Sender: TObject);
begin
   SaveLst(Memo3);
end;
// -----------------------------------------------------------------
//  
procedure TForm1.sbtnTickedsSaveClick(Sender: TObject);
begin
   SaveLst(Memo4);
end;
// -----------------------------------------------------------------
//        WORD
// -----------------------------------------------------------------
procedure TForm1.btnToWordClick(Sender: TObject);
var wList  : TStringList;
    wStr   : string;
begin
    //    MS Word
    if not ExistsMSWord() then Exit;
    //   CP1251  MS Word
    wList :=  TStringList(Memo4.Lines);
    wStr := ExtSaveDialog(' : ', '.doc');
    if  CP1251ToDoc(
                     // StringList  
                     wList,
                     //   
                     wStr)
    then begin
       ShowMessage(' ');
    end;
end;
// -----------------------------------------------------------------
//    / 
// -----------------------------------------------------------------
procedure TForm1.FormCreate(Sender: TObject);
begin
   Lst1 := TStringList.Create;
   Lst2 := TStringList.Create;
   Lst3 := TStringList.Create;

   Memo1.ScrollBars := ssBoth;
   Memo2.ScrollBars := ssBoth;
   Memo3.ScrollBars := ssBoth;
   Memo4.ScrollBars := ssBoth;

end;
// -----------------------------------------------------------------
procedure TForm1.FormDestroy(Sender: TObject);
begin
   Lst1.Free;
   Lst2.Free;
   Lst3.Free;
end;
// -----------------------------------------------------------------
//      
// -----------------------------------------------------------------



end.
