unit MiniCalc1;

//  .
//    ()  .. (   ).
//       .
//       
// ,      
//    ,    
// .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ActnList, Grids, ComCtrls,
  //  units
  Math, StrUtils;

//    
type
  TMiniCalc = class(TForm)
    //   
    PanelNumBoard: TPanel;
    ButtonD1: TButton;
    ButtonD2: TButton;
    ButtonD3: TButton;
    ButtonD4: TButton;
    ButtonD5: TButton;
    ButtonD6: TButton;
    ButtonD7: TButton;
    ButtonD8: TButton;
    ButtonD9: TButton;
    ButtonD0: TButton;
    ButtonComma: TButton;
    ButtonSign: TButton;
    ButtonDE: TButton;
    ButtonEsc: TButton;    // Tag := 0;
    //    
    PanelOpBoard: TPanel;
    ButtonEnter: TButton;  // Tag := 0;
    ButtonPlus: TButton;   // Tag := 201;
    ButtonMinus: TButton;  // Tag := 202;
    ButtonMult: TButton;   // Tag := 203;
    ButtonDv: TButton;     // Tag := 204;
    ButtonDiv: TButton;    // Tag := 205;
    ButtonMod: TButton;    // Tag := 206;
    ButtonXupY: TButton;   // Tag := 207;
    //    
    PanelDisplay: TPanel;
    lbALUIn2RG: TLabel;
    stALUIn2RG: TStaticText;
    stALUOpCodS: TStaticText;
    lbALUIn1RG: TLabel;
    edDisplay: TEdit;
    //     
    PanelTrigonometry: TPanel;
    ButtonSin: TButton;    // Tag := 331;
    ButtonCos: TButton;    // Tag := 332;
    ButtonTan: TButton;    // Tag := 333;
    ButtonCot: TButton;    // Tag := 334;
    ButtonArcSin: TButton; // Tag := 361;
    ButtonArcCos: TButton; // Tag := 362;
    ButtonArcTan: TButton; // Tag := 363;
    ButtonArcCot: TButton; // Tag := 364;
    cboxRadGrad: TComboBox;
    //     
    PanelConst: TPanel;
    ButtonPi: TButton;
    ButtonE: TButton;
    ButtonAbs: TButton;    // Tag := 391;
    ButtonSqrt: TButton;   // Tag := 392;
    //     
    PanelExpLn: TPanel;
    ButtonExp: TButton;    // Tag := 301;
    ButtonLn: TButton;     // Tag := 302;
    ButtonLog10: TButton;  // Tag := 303;
    ButtonLog2: TButton;   // Tag := 304;
    //     
    PanelMemory: TPanel;
    ButtonMSave: TButton;
    cboxMRGNumb: TComboBox;
    edMRGVal: TEdit;
    ButtonMLoad: TButton;
    edMRGComment: TEdit;
    lbMRGNumb: TLabel;
    lbMRGVal: TLabel;
    lbMRGComment: TLabel;
    //       
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    memoReport: TMemo;
    sgridMRG: TStringGrid;
    ButtonClearReport: TButton;
    ButtonSaveReport: TButton;
    // -----------------------------------------------
    //  
    procedure FormActivate(Sender: TObject);
    procedure ButtonEnterClick(Sender: TObject);
    procedure ButtonEscClick(Sender: TObject);
    procedure ButtonClearReportClick(Sender: TObject);
    procedure ButtonSaveReportClick(Sender: TObject);
    procedure ButtonEClick(Sender: TObject);
    procedure ButtonPiClick(Sender: TObject);
    procedure ButtonCommaClick(Sender: TObject);
    procedure ButtonDEClick(Sender: TObject);
    procedure ButtonSignClick(Sender: TObject);
    procedure cboxMRGNumbClick(Sender: TObject);
    procedure ButtonMSaveClick(Sender: TObject);
    procedure ButtonMLoadClick(Sender: TObject);
    procedure sgridMRGClick(Sender: TObject);
    // -----------------------------------------------
    //   .
    //        
    // -----------------------------------------------
    //       
    procedure ButtonDigitClick(Sender: TObject);
    //       .
    procedure ButtonOp2Click(Sender: TObject);
    //       .
    procedure ButtonOp1Click(Sender: TObject);

  private
    { Private declarations }
    // -----------------------------------------------
    //    .
    //     ALU
    // -----------------------------------------------
    // /   ALURG.In2RG
    procedure ViewDisplayIn2RG(RqView : boolean);
    //    In1RG
    procedure ClearIn1RG();
    //    In2RG
    procedure ClearIn2RG();
    //    ALU
    procedure ViewOpCodS();
    //    RGOut  In1RG
    procedure MoveRGOutToIn1RG();
    //       ALURG.In1RG
    function  MoveDisplayToIn1RG() : boolean;
    //       ALURG.In2RG
    function  MoveDisplayToIn2RG() : boolean;
    //   
    procedure ResetCalcALU();
    // -----------------------------------------------
    //    .
    //      
    // -----------------------------------------------
    //        ( 1)
    procedure LoadOpCodAndOperand1(RqButton : TButton);
    //       ( 2)
    procedure LoadOperand2AndRunOperation();
    //     ALU  ( 3)
    procedure RunALU2Operation();
    // -----------------------------------------------
    // 
    //      
    // -----------------------------------------------
    //         
    function Trigonom(RqFunc : integer; RqArg : double) : double;
    //         
    function ArcTrigonom (RqFunc : integer; RqArg : double) : double;
    //    ,  ,
    //     ( 1)
    procedure LoadOpCodAndOperandAndRun(RqButton : TButton);
    //     ALU  ( 2)
    procedure RunALU1Operation();
    // -----------------------------------------------
    // 
    //   
    // -----------------------------------------------
    //    
    procedure ClearAndInitReport();
    //    
    procedure SaveReport();
    // -----------------------------------------------
    // 
    //    
    // -----------------------------------------------
    //   
    procedure ClearArrMRG();
    //       
    procedure SelectArrMRG(RqRGNum : integer);
    //     
    procedure SaveToSelectMRG(RqRGNum : integer);
    //     
    procedure LoadFromSelectMRG(RqRGNum : integer);

  public
    { Public declarations }
  end;

//    
var MiniCalc: TMiniCalc;

// ------------------------------------------------------------------
implementation
{$R *.dfm}
// ------------------------------------------------------------------

//   
const MaxNumMRG  = 12;

type TALURG = record
  //  - 
  // Arithmetic and logic unit registers (ALURG)
  OpCodS   : string;   //    
  OpCodRG  : integer;  //    
  In1RG    : double;   //   1
  In2RG    : double;   //   2
  RGOut    : double;   //  
  ErrRG    : boolean;  //   
end;

//  - 
var ALURG : TALURG;

// ------------------------------------------------------------------
//   
// ------------------------------------------------------------------
//         
function StrToDoublePro (InStr : string; var OutDouble : double) : boolean;
begin
   Result := False;   //  
   try
      //  
      OutDouble := StrToFloat(InStr);
      //  
      Result := True;
   except
      //    
      ShowMessage('    ');
   end;
end;

// ------------------------------------------------------------------
//     ALU 
//        
//  ,   
//  -  .
//   ,  
//     .
// ------------------------------------------------------------------
// /   ALURG.In2RG
procedure TMiniCalc.ViewDisplayIn2RG(RqView : boolean);
begin
  stALUIn2RG.Visible  := RqView;
  lbALUIn2RG.Visible  := RqView;
end;

//    In1RG
procedure TMiniCalc.ClearIn1RG();
begin
   ALURG.In2RG := 0;
   edDisplay.Text := '';
end;

//    In2RG
procedure TMiniCalc.ClearIn2RG();
begin
   ALURG.In2RG := 0;
   stALUIn2RG.Caption := '';
   ViewDisplayIn2RG(False);
end;

//    ALU
procedure TMiniCalc.ViewOpCodS();
begin
   stALUOpCodS.Caption := ALURG.OpCodS;
end;

//    RGOut  In1RG
procedure TMiniCalc.MoveRGOuttoIn1RG();
begin
   ALURG.In1RG := ALURG.RGOut;
   edDisplay.Text := FloatToStr (ALURG.RGOut);
end;

//       ALURG.In1RG
function TMiniCalc.MoveDisplayToIn1RG() : boolean;
begin
  Result := False;              //  
  if  edDisplay.Text <> ''
  then Result := StrToDoublePro (edDisplay.Text, ALURG.In1RG);
end;

//       ALURG.In2RG
function TMiniCalc.MoveDisplayToIn2RG() : boolean;
begin
  Result := False;              //  
  if  edDisplay.Text <> ''
  then begin
    Result := StrToDoublePro (edDisplay.Text, ALURG.In2RG);
    if Result
    then begin
       stALUIn2RG.Caption := edDisplay.Text;
       ViewDisplayIn2RG(True);
    end;
  end;
end;

//   
procedure TMiniCalc.ResetCalcALU();
begin
  ALURG.OpCodS := '='; //   
  ALURG.OpCodRG := 0;  //   
  stALUOpCodS.Caption := '';
  ClearIn1RG();
  ClearIn2RG();
end;

// ------------------------------------------------------------------
//      
//          
//       .
// ------------------------------------------------------------------
//       ( 1)
procedure TMiniCalc.LoadOpCodAndOperand1(RqButton : TButton);
begin
  if  edDisplay.Text <> ''
  then begin
    //     In2RG
    if MoveDisplayToIn2RG()
    then begin
      //     .
      //    
      ALURG.OpCodRG := RqButton.Tag;
      //     
      ALURG.OpCodS := Trim(RqButton.Caption);
      ViewOpCodS();
      edDisplay.Text := '';
    end;
  end;
end;

//       ( 2)
procedure TMiniCalc.LoadOperand2AndRunOperation();
begin
  if  edDisplay.Text <> ''
  then begin
    if MoveDisplayToIn1RG()
    then begin
      if ALURG.OpCodRG > 0
      then RunALU2Operation;
    end;
  end;
end;

//     ALU  ( 3)
procedure TMiniCalc.RunALU2Operation();
var Int1, Int2 : Int64;   //    double
    RepStr     : string;  //   
begin
with ALURG do
begin
  ErrRG := True;   //  
  try
    case OpCodRG of
    201: RGOut := In2RG + In1RG;                // '+'
    202: RGOut := In2RG - In1RG;                // '-'
    203: RGOut := In2RG * In1RG;                // '*'
    204: RGOut := In2RG / In1RG;                // '/'
    205: begin                                  // 'div'
            //      ,
            //    Exception
            if (Abs(In1RG - Trunc(In1RG)) > 0) or
               (Abs(In2RG - Trunc(In2RG)) > 0)
            then raise Exception.Create(' DIV  '
                                       + #13#10
                                       + '   ');
            //    integer
            Int1 := Trunc(In1RG);
            Int2 := Trunc(In2RG);
            RGOut := Int2 div Int1;             //  DIV
         end;
    206: begin                                  // 'mod'
            //      ,
            //    Exception
            if (Abs(In1RG - Trunc(In1RG)) > 0) or
               (Abs(In2RG - Trunc(In2RG)) > 0)
            then raise Exception.Create(' MOD  '
                                       + #13#10
                                       + '   ');
            //    integer
            Int1 := Trunc(In1RG);
            Int2 := Trunc(In2RG);
            RGOut := Int2 mod Int1;           //  MOD
         end;
    207: RGOut := Power(In2RG,In1RG);         // 'x^y'
    end; {of case ALURG.OpCodS}
    //  Report
    memoReport.Lines.Add(DupeString('--', 40));
    RepStr  := ' [OpCode = '
            + IntToStr(OpCodRG) +  '] :';
    memoReport.Lines.Add(RepStr);
    RepStr  := ' ' + FloatToStr(In2RG)
            +  ' ' + OpCodS
            +  ' ' + FloatToStr(In1RG)
            +  ' = ' +  FloatToStr(RGOut);
    memoReport.Lines.Add(RepStr);
    //   ALU
    ErrRG   := False;  //  
    OpCodRG := 0;      //   
    OpCodS  := '=';    //   
  except
    // ----------------------------------------------------
    //      
    on EZeroDivide   do MessageDlg('    ',
                                    mtWarning, [mbOk], 0);
    on EOverflow     do MessageDlg(' ',
                                    mtWarning, [mbOk], 0);
    // ----------------------------------------------------
    //   (EM, EE)    Exception
    //    (.Message)   
    //   .
    on EM:EMathError do MessageDlg(EM.Message, mtWarning, [mbOk], 0);
    on EE:Exception  do MessageDlg(EE.Message, mtWarning, [mbOk], 0);
    // ----------------------------------------------------
  end; // of try
  //    ALU
  ViewOpCodS();
  if not ErrRG
  then begin
     //     
     MoveRGOuttoIn1RG();
     //    In2RG
     ClearIn2RG();
  end;
end; // of with ALURG
end;

// ------------------------------------------------------------------
//      
//          
//       .
// ------------------------------------------------------------------
//    ,  ,
//     ( 1)
procedure TMiniCalc.LoadOpCodAndOperandAndRun(RqButton : TButton);
begin
  if  edDisplay.Text <> ''
  then begin
    //     In1RG
    if MoveDisplayToIn1RG()
    then begin
      //     .
      //    
      ALURG.OpCodRG := RqButton.Tag;
      //     
      ALURG.OpCodS := Trim(RqButton.Caption);
      ViewOpCodS();
      //  
      RunALU1Operation();
    end;
  end;
end;

//         
function TMiniCalc.Trigonom (RqFunc : integer; RqArg : double) : double;
var Angle : double;
begin
   Angle := RqArg;                //   
   if cboxRadGrad.ItemIndex > 0
   then begin
     //     
     Angle := 2 * Pi * RqArg / 360;
   end;
   case RqFunc of
   331: Result := Sin(Angle);     // Sin
   332: Result := Cos(Angle);     // Cos
   333: Result := Tan(Angle);     // Tan
   334: Result := Cot(Angle);     // Cot
   else Result := 0;
   end;
end;

//         
function TMiniCalc.ArcTrigonom (RqFunc : integer; RqArg : double) : double;
var Angle : double;
begin
   case RqFunc of
   361: Angle := ArcSin(RqArg);  // ArcSin
   362: Angle := ArcCos(RqArg);  // ArcCos
   363: Angle := ArcTan(RqArg);  // ArcTan
   364: Angle := ArcCot(RqArg);  // ArcCot
   else Angle := 0;
   end;
   Result := Angle;              //   
   if cboxRadGrad.ItemIndex > 0
   then begin
     //     .
     Result := (360 * Angle) / (2 * Pi);
   end;
end;

//     ALU  ( 2)
procedure TMiniCalc.RunALU1Operation();
var RepStr : string;  //   
begin
with ALURG do
begin
  ErrRG := True;   //  
  try
    case ALURG.OpCodRG of
    //   
    301: RGOut := Exp(In1RG);     // Exp
    302: RGOut := Ln(In1RG);      // Ln
    303: RGOut := Log10(In1RG);   // Log10
    304: RGOut := Log2(In1RG);    // Log2
    331.. 334: begin //   
                 RGOut := Trigonom (ALURG.OpCodRG, In1RG);
               end;
    361.. 364: begin //   
                 RGOut := ArcTrigonom (ALURG.OpCodRG, In1RG);
               end;
    // 
    391: RGOut := Abs(In1RG);     // Abs
    392: RGOut := Sqrt(In1RG);    // Sqrt
    end; {of case ALURG.OpCodS}
    //    Report
    memoReport.Lines.Add(DupeString('--', 40));
    RepStr  := ' [OpCode = ' + IntToStr(OpCodRG) +  ']';
    case ALURG.OpCodRG of
    331.. 334: begin //   
                 if cboxRadGrad.ItemIndex = 0
                 then RepStr  := RepStr + '   :'
                 else RepStr  := RepStr + '   :'
               end;
    361.. 364: begin //   
                 if cboxRadGrad.ItemIndex = 0
                 then RepStr  := RepStr + '   :'
                 else RepStr  := RepStr + '   :'
               end;
          else RepStr  := RepStr + ' :';
    end;
    memoReport.Lines.Add(RepStr);
    //    Report
    RepStr  := ' ' + OpCodS
            + '(' + FloatToStr(In1RG)+ ') = '
            +  FloatToStr(RGOut);
    memoReport.Lines.Add(RepStr);
    //   ALU
    ErrRG   := False;  //  
    OpCodRG := 0;      //   
    OpCodS  := '=';    //   
  except
    // ----------------------------------------------------
    //      
    on EInvalidArgument do MessageDlg('  ',
                                       mtWarning, [mbOk], 0);
    on EUnderflow	      do MessageDlg(' ',
                                       mtWarning, [mbOk], 0);
    on EInvalidOp		    do MessageDlg('  ',
                                       mtWarning, [mbOk], 0);
    on EOverflow        do MessageDlg(' ',
                                       mtWarning, [mbOk], 0);
    // ----------------------------------------------------
    //   (EM, EE)    Exception
    //    (.Message)   
    //   .
    on EM:EMathError do MessageDlg(EM.Message, mtWarning, [mbOk], 0);
    // ----------------------------------------------------
  end; // of try
  //    ALU
  ViewOpCodS();
  if not ALURG.ErrRG
  then begin
     //     
     MoveRGOuttoIn1RG();
     //    In2RG
     ClearIn2RG();
  end;
end; // of with ALURG
end;

// ------------------------------------------------------------------
//     
//    
procedure TMiniCalc.ClearAndInitReport();
begin
   memoReport.Clear;
   memoReport.Lines.Add(' .');
   memoReport.Lines.Add('  : ' + DateTimeToStr(Now));
end;
//    
procedure TMiniCalc.SaveReport();
begin
  try
    memoReport.Lines.Add(DupeString('--', 40));
    memoReport.Lines.Add('   : ' + DateTimeToStr(Now));
    memoReport.Lines.SaveToFile('.\Report.txt');
    memoReport.Lines.Add('    ');
  except
    memoReport.Lines.Add('       ');
  end;
end;

//   
procedure TMiniCalc.ClearArrMRG();
var Ind : integer;
begin
  //    
  cboxMRGNumb.Clear;
  //    
  sgridMRG.Cells[0,0] := 'Num';
  sgridMRG.Cells[1,0] := ' RG';
  sgridMRG.Cells[2,0] := '';
  sgridMRG.RowCount := MaxNumMRG + 1;
  for Ind := 1 to MaxNumMRG do
  begin
     //    
     sgridMRG.Cells[0,Ind] := IntToStr(Ind);
     sgridMRG.Cells[1,Ind] := '';
     sgridMRG.Cells[2,Ind] := '';
     //    
     cboxMRGNumb.Items.Add(IntToStr(Ind));
  end;
  //    
  cboxMRGNumb.ItemIndex := 0;
end;

//       
procedure TMiniCalc.SelectArrMRG(RqRGNum : integer);
begin
   edMRGVal.Text := sgridMRG.Cells[1,RqRGNum];
   edMRGComment.Text := sgridMRG.Cells[2,RqRGNum];
end;

//     
procedure TMiniCalc.SaveToSelectMRG(RqRGNum : integer);
begin
   edMRGVal.Text := edDisplay.Text;
   sgridMRG.Cells[1,RqRGNum] := edMRGVal.Text;
   sgridMRG.Cells[2,RqRGNum] := edMRGComment.Text;
end;

//     
procedure TMiniCalc.LoadFromSelectMRG(RqRGNum : integer);
begin
  SelectArrMRG(RqRGNum);
  edDisplay.Text := edMRGVal.Text;
end;

// ------------------------------------------------------------------
//        
//          -
// ,      
//   .
//          
//   ,    
// onClick    .     
//      .   
//     (Object Inspector/Events
// /onClick)

// ------------------------------------------------------------------
//      
// ------------------------------------------------------------------
//       .
//      
procedure TMiniCalc.ButtonDigitClick(Sender: TObject);
var WButt : TButton;  //     TButton
    WStr  : string;   //  
begin
 if Sender is TButton
 then begin
   //  Sender  ,  
   //    ,     .
   WButt := Sender as TButton;
   //     
   WStr  := Trim(WButt.Caption);
   edDisplay.Text := edDisplay.Text + WStr[1];
 end;
end;

//      
procedure TMiniCalc.ButtonCommaClick(Sender: TObject);
begin
  //     
  if PosEx(',',edDisplay.Text) = 0
  then begin
    //    ,   
    edDisplay.Text := edDisplay.Text + ',';
  end
  else begin
     MessageDlg('     ',
                mtWarning, [mbOk], 0);
  end;
end;

//       'E'
procedure TMiniCalc.ButtonDEClick(Sender: TObject);
var Ind : integer;   //  
begin
  //      
  Ind := PosEx('E',UpperCase(edDisplay.Text));
  if Ind = 0
  then begin
    //    
    if Length(edDisplay.Text) > 0
    then edDisplay.Text := edDisplay.Text + 'E'
    else MessageDlg('.  .',
                    mtWarning, [mbOk], 0);
  end
  else begin
     MessageDlg('.   .',
                mtWarning, [mbOk], 0);
  end;
end;

//      
procedure TMiniCalc.ButtonSignClick(Sender: TObject);
var Ind1, Ind2 : integer;   //  
begin
  //      
  Ind1 := PosEx('-',edDisplay.Text);
  if Ind1 = 0
  then begin
    //    
    if Length(edDisplay.Text) = 0
    then edDisplay.Text := '-'
    else begin
       //   
       Ind2 := Length(edDisplay.Text);  //   
       if UpperCase(edDisplay.Text[Ind2]) = 'E'
       then begin
          edDisplay.Text := edDisplay.Text + '-';
       end;   
    end;
  end
  else begin
    //   
    if Length(edDisplay.Text) > 0
    then begin
       //   
       Ind2 := Length(edDisplay.Text);  //   
       if UpperCase(edDisplay.Text[Ind2]) = 'E'
       then begin
         edDisplay.Text := edDisplay.Text + '-';
       end;
    end;
  end;
end;

// ------------------------------------------------------------------
//       
// ------------------------------------------------------------------
//       
procedure TMiniCalc.ButtonEClick(Sender: TObject);
begin
  edDisplay.Text := FloatToStr(Exp(1));
end;

//      
procedure TMiniCalc.ButtonPiClick(Sender: TObject);
begin
  edDisplay.Text := FloatToStr(Pi);
end;

// ------------------------------------------------------------------
//        
// ------------------------------------------------------------------
//       .
procedure TMiniCalc.ButtonOp2Click(Sender: TObject);
begin
 if Sender is TButton
 then begin
   //  Sender  
   LoadOpCodAndOperand1(Sender as TButton);
 end;
end;

//       .
procedure TMiniCalc.ButtonOp1Click(Sender: TObject);
begin
 if Sender is TButton
 then begin
   //  Sender  
   LoadOpCodAndOperandAndRun(Sender as TButton);
 end;
end;

//     '='.
procedure TMiniCalc.ButtonEnterClick(Sender: TObject);
begin
   //      
   LoadOperand2AndRunOperation();
end;

//     ''.
procedure TMiniCalc.ButtonEscClick(Sender: TObject);
begin
  ResetCalcALU(); //  
end;

//      
procedure TMiniCalc.FormActivate(Sender: TObject);
begin
  //  
  ResetCalcALU();
  //     
  ClearArrMRG();
  //    
  ClearAndInitReport();
end;

// ------------------------------------------------------------------
//      
// ------------------------------------------------------------------
//    
procedure TMiniCalc.ButtonClearReportClick(Sender: TObject);
begin
   ClearAndInitReport();
end;

//    
procedure TMiniCalc.ButtonSaveReportClick(Sender: TObject);
begin
  SaveReport();
end;

// ------------------------------------------------------------------
//      
// ------------------------------------------------------------------
//  MRG   
procedure TMiniCalc.cboxMRGNumbClick(Sender: TObject);
begin
 SelectArrMRG(cboxMRGNumb.ItemIndex + 1);
end;

//     MRG
procedure TMiniCalc.ButtonMSaveClick(Sender: TObject);
begin
 SaveToSelectMRG(cboxMRGNumb.ItemIndex + 1);
end;

//     MRG
procedure TMiniCalc.ButtonMLoadClick(Sender: TObject);
begin
 LoadFromSelectMRG(cboxMRGNumb.ItemIndex + 1);
end;

//  MRG   StringGrid
procedure TMiniCalc.sgridMRGClick(Sender: TObject);
begin
   //     
   cboxMRGNumb.ItemIndex := sgridMRG.Row - 1;
   //    .
   SelectArrMRG(sgridMRG.Row);
end;

// ------------------------------------------------------------------
//    
// ------------------------------------------------------------------



end.
