unit UnitNote;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  StrUtils, Dialogs, StdCtrls, Printers,
  MainData, Buttons;

type
  TFormNote = class(TForm)
    MemoNote: TMemo;
    BitBtnSaveNote: TBitBtn;
    BitBtnCloseNote: TBitBtn;
    BitBtnPrintNone: TBitBtn;
    PrintDialog1: TPrintDialog;
    Label1: TLabel;
    procedure FormShow(Sender: TObject);
    procedure BitBtnCloseNoteClick(Sender: TObject);
    procedure BitBtnSaveNoteClick(Sender: TObject);
    procedure BitBtnPrintNoneClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormNote: TFormNote;

implementation

{$R *.dfm}

const LineLen = 80;
      CharSep = '~';
// ========================================================================
//               
// ========================================================================
// ------------------------------------------------------------------------
//    
procedure TFormNote.FormShow(Sender: TObject);
begin
   MemoNote.Clear;
   if not FileExists(NoteFileName)
   then begin
      MemoNote.Lines.Add('              '
                      + NoteDay   + '-'
                      + NoteMonth + '-'
                      + NoteYear);
      MemoNote.Lines.Add(DupeString(CharSep, LineLen));
      MemoNote.Lines.Add('');
   end
   else begin
      try
        MemoNote.Lines.LoadFromFile(NoteFileName);
      except
         MessageDlg('   :'
           + #13#10 + NoteFileName
           + #13#10 + '    ...',
           mtError, [mbOk], 0);
      end;
   end;
end;
// ------------------------------------------------------------------------
//       
procedure TFormNote.BitBtnCloseNoteClick(Sender: TObject);
begin
    NoteOK := True;
    Close;
end;
// ------------------------------------------------------------------------
//       
procedure TFormNote.BitBtnSaveNoteClick(Sender: TObject);
begin
    NoteOK := True;
    //  ,   NOTEs
    if not DirectoryExists(ApplicationDir + '\NOTEs')
    then NoteOK := ForceDirectories(ApplicationDir + '\NOTEs');
    if NoteOK
    then begin
       try
          MemoNote.Lines.SaveToFile(NoteFileName);
          NoteOK := True;
       except NoteOK := False; end;
       if not NoteOK
       then begin
          if FileExists(NoteFileName)
          then DeleteFile(NoteFileName);
          MessageDlg('   :'
             + #13#10 + NoteFileName,
             mtError, [mbOk], 0);
       end;
    end
    else MessageDlg('   :'
          + #13#10 + ApplicationDir + '\NOTEs',
          mtError, [mbOk], 0);
    //  
    Close;
end;

// ------------------------------------------------------------------------
//     
procedure TFormNote.BitBtnPrintNoneClick(Sender: TObject);

var BorderX   : integer;  //   
    BorderY   : integer;  //   
    PageCount : integer;  //  
    Y         : integer;
    Ind       : integer;
    wStr      : string;
begin
  //  
  if not PrintDialog1.Execute then Exit;
  with Printer do
  begin
     PageCount := 0;
     Canvas.Font.Name := 'Tachoma';
     Canvas.Font.Size := 10;
     BorderY := 5 *(Canvas.TextHeight('1') + 20);
     BorderX := 4 *(Canvas.TextWidth('W'));
     BeginDoc;
     Canvas.FillRect(Rect(0,0,PageWidth,PageHeight));
     Y := BorderY;
     //     
     for Ind := 0 to MemoNote.Lines.Count - 1
     do begin
        wStr := MemoNote.Lines[Ind];
        Canvas.TextOut(BorderX, Y, wStr);
        Y := Y + Canvas.TextHeight(wStr) + 20;
        if Y >= PageHeight - BorderY
        then begin
            //   
            Inc(PageCount);
            Canvas.TextOut(BorderX, Y, DupeString(CharSep, LineLen));
            Y := Y + Canvas.TextHeight(wStr) + 20;
            Canvas.TextOut(BorderX, Y, '.'+ IntToStr(PageCount));
            //    
            Y := BorderY;
            NewPage;
            Canvas.FillRect(Rect(0,0,PageWidth,PageHeight));
        end;
     end;
     EndDoc;
  end;
end;


// ========================================================================
//                       
// ========================================================================


end.
