unit ToView;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StrUtils, Jpeg,
  MainData, ExtCtrls, Buttons, StdCtrls;

type
  TToViewForm1 = class(TForm)
    ScrollBox1: TScrollBox;
    Image1: TImage;
    SpButSaveImg: TSpeedButton;
    SaveDialog1: TSaveDialog;
    StTxtFon: TStaticText;
    StTxtField: TStaticText;
    Label1: TLabel;
    Label2: TLabel;
    StTxtWday: TStaticText;
    StTxtFDay: TStaticText;
    Label3: TLabel;
    Label4: TLabel;
    CmbBoxBolds: TComboBox;
    ColorDialog1: TColorDialog;
    CmbBoxBorder: TComboBox;
    StTxtText: TStaticText;
    Label5: TLabel;
    SpButUnDoColors: TSpeedButton;
    procedure FormShow(Sender: TObject);
    procedure SpButSaveImgClick(Sender: TObject);
    procedure CmbBoxBoldsClick(Sender: TObject);
    procedure StTxtWdayClick(Sender: TObject);
    procedure StTxtFDayClick(Sender: TObject);
    procedure CmbBoxBorderClick(Sender: TObject);
    procedure StTxtFonClick(Sender: TObject);
    procedure StTxtFieldClick(Sender: TObject);
    procedure StTxtTextClick(Sender: TObject);
    procedure SpButUnDoColorsClick(Sender: TObject);
  private
    { Private declarations }
      //     
      procedure ImageClear(RqImage : TImage; RqColor : TColor);
      //    
      procedure ResetFontStyle (RqControl : TControl;
                                RqRow, RqBolds : integer);
      //      
      procedure PaintMonth (RqControl : TControl;
                            MonthName : string;
                            RqStyle, RqBolds : integer;
                            StartX, StartY   : integer;
                            var XEnd, YEnd   : integer);
      //     ( : 3col * 4row )
      procedure Paint12Month(RqControl : TControl; RqYearTxt : string);
      //   
      procedure ReShowCalendar();
  public
    { Public declarations }
  end;

var
  ToViewForm1 : TToViewForm1;

// ========================================================================
// ========================================================================
implementation
{$R *.dfm}
// ========================================================================
// ========================================================================

// ========================================================================
//    IMAGE 12   
// ========================================================================
// ------------------------------------------------------------------------
// 24.11.2014
//    
procedure  TToViewForm1.ResetFontStyle (RqControl : TControl;
                                         RqRow, RqBolds : integer);
begin
  with RqControl as TImage do
  begin
           //  
           case RqBolds of
             0 : begin
                    Canvas.Font.Style :=[];
                    case RqRow of
                      1..5 : Canvas.Font.Color := StTxtWday.Color;
                      6..7 : Canvas.Font.Color := StTxtFDay.Color;
                      8..9 : Canvas.Font.Color := StTxtWday.Color;
                    end;
                 end;
             1 : case RqRow of
                  1..5 : begin
                           Canvas.Font.Color := StTxtWday.Color;
                           Canvas.Font.Style := [];         // 
                         end;
                  6..7 : begin
                           Canvas.Font.Color := StTxtFDay.Color;
                           Canvas.Font.Style := [fsBold];   // 
                         end;
                  8..9 : begin
                           Canvas.Font.Color := StTxtWday.Color;
                           Canvas.Font.Style := [];         // 
                         end;
                 end;
             2 : case RqRow of
                  1..5 : begin
                           Canvas.Font.Color := StTxtWday.Color;
                           Canvas.Font.Style := [fsBold];   // 
                         end;
                  6..7 : begin
                           Canvas.Font.Color := StTxtFDay.Color;
                           Canvas.Font.Style := [];         // 
                         end;
                  8..9 : begin
                           Canvas.Font.Color := StTxtWday.Color;
                           Canvas.Font.Style := [];         // 
                         end;
                 end;
             3 : case RqRow of
                  1..5 : begin
                           Canvas.Font.Color := StTxtWday.Color;
                           Canvas.Font.Style := [fsBold];   // 
                         end;
                  6..7 : begin
                           Canvas.Font.Color := StTxtFDay.Color;
                           Canvas.Font.Style := [fsBold];   // 
                         end;
                  8..9 : begin
                           Canvas.Font.Color := StTxtWday.Color;
                           Canvas.Font.Style := [];         // 
                         end;
                 end;
           end;
  end;
end;

// ------------------------------------------------------------------------
// 24.11.2014
//      
procedure TToViewForm1.PaintMonth (RqControl : TControl;
                                    MonthName : string;
                                    RqStyle, RqBolds : integer;
                                    StartX, StartY   : integer;
                                    var XEnd, YEnd   : integer);
var BegX, BegY    : integer;
    ChW,  ChH     : integer;
    wRow, wCol    : integer;
    wStr          : string;
    X1,Y1,X2,Y2   : integer;
begin
  with RqControl as TImage do
  begin
     Canvas.Brush.Style := bsClear;
     ChW := Canvas.TextWidth('1234') + 10;
     ChH := Canvas.TextHeight('1')   + 15;
     BegX := StartX;
     BegY := StartY;
     // 
     Canvas.Font.Color := StTxtText.Color;
     Canvas.Font.Style := [fsBold];
     Canvas.TextOut(BegX, BegY, MonthName);
     // 
     Canvas.Brush.Style := bsSolid;
     Canvas.Brush.Color := StTxtField.Color;
     BegY := BegY + Canvas.TextHeight('1') + 5;   //   . 
     for wRow := Low(TabMonthDay) to High(TabMonthDay)
     do begin
        BegX := StartX;
        //  
        ResetFontStyle (RqControl, wRow, RqBolds);
        //   
        for wCol := Low(TabMonthDay[wRow]) to High(TabMonthDay[wRow])
        do begin
           //  
           X1 := BegX;
           Y1 := BegY;
           X2 := BegX + ChW;
           Y2 := BegY + ChH;
           case CmbBoxBorder.ItemIndex of
             0 : Canvas.Rectangle(X1,Y1,X2+1,Y2+1);  // ( )
             1 : Canvas.Rectangle(X1,Y1,X2-1,Y2-1);  //  ( )
           end;
           //   
           wStr := TabMonthDay[wRow, wCol];
           Canvas.TextOut(BegX + (ChW div 4), BegY + 10, wStr);
           BegX := BegX + ChW;
        end;
        BegY := BegY + ChH;
     end;
     XEnd := BegX;
     YEnd := BegY;
     Canvas.Brush.Style := bsClear;
  end;
end;
// ------------------------------------------------------------------------
// 24.11.2014
//     ( : 3col * 4row )
procedure TToViewForm1.Paint12Month(RqControl : TControl; RqYearTxt : string);
const BorderY = 20; //   
      BorderX = 20; //   
var IndRow        : integer;
    IndCol        : integer;
    Ind           : integer;
    PageX, PageY  : integer;
    BegX, BegY    : integer;
    XEnd, YEnd    : integer;
    wStr : string;
begin
  //   12 
  with RqControl as TImage do
     begin
     //    
     Canvas.Font.Name := 'Arial';    // 'MS Sans Serif'
     Canvas.Font.Size := 14;
     Canvas.Font.Color := StTxtText.Color;
     Canvas.Pen.Width := 1;
     Canvas.Brush.Style := bsClear;
     PageX := BorderX;
     PageY := BorderY;

     BegY := PageY;
     wStr := RqYearTxt;
     //  
     BegX := Canvas.TextWidth(wStr) div 2;
     BegX := (Width div 2) - BegX;
     //  
     Canvas.TextOut(BegX, BegY, wStr);
     BegY := BegY + 2 * Canvas.TextHeight(wStr);
     //      
      Canvas.Font.Size := 10;
      XEnd   := 0;
      YEnd   := 0;
      for IndRow := 1 to 4
      do begin
         BegX := PageX;
         for IndCol := 1 to 3
         do begin
           Ind := 3 * (IndRow - 1) + IndCol;
           //   
           MonthToTabMonthDay(Ind, TabMonthDay);
           //   
           PaintMonth (RqControl,
                       ArrMonthDesc[Ind].Name,
                       1, CmbBoxBolds.ItemIndex,
                       BegX, BegY,
                       XEnd, YEnd);
           BegX := XEnd + 20;
         end;
         BegY := YEnd + 20;
      end;
      //  
      if NumFormatYear = 1
      then begin
         Canvas.Font.Color := StTxtText.Color;
         Canvas.Font.Style := [];
         BegY := YEnd + 20;
         Canvas.TextOut(PageX, BegY, '*  -   ');
         BegY := BegY + Canvas.TextHeight('1');
         Canvas.TextOut(PageX, BegY, '** -    ');
      end;

  end;
end;

// --------------------------------------------------------------------
// 24.11.2014
//  Image  . (RqGFormat: 'J' - jpg   'B' -bmp)
procedure ImageToFile(RqImage    : TImage;
                      RqFileName : string;
                      RqGFormat  : char);
var  wPath, wName, wExt, wFileName : string;
     wPPos  : word;
     wOK    : boolean;
var  Jpeg   : TJPEGImage;  //   unit jpeg.
     BitMap : TBitMap;
begin
   wOK   := False;
   wPath := ExtractFilePath(RqFileName);  //  'Disk:\dir1\..\DirN\'
   wName := ExtractFileName(RqFileName);  //  'Name.Ext'  ''
   WExt  := ExtractFileExt(wName);        //  '.Ext'  ''
   if Length(WExt) > 0
   then begin
       //   
       wPPos := Pos('.', wName);
       if (wPPos > 1)
       then begin
            wName := LeftStr(wName,wPPos-1);
            wFileName := wPath + wName;
            wOK := True;
       end;
   end
   else begin
       //     ( )
       wFileName := wPath + wName;
       wOK := True;
   end;
   if WOk
   then begin
       case UpCase(RqGFormat) of
       // ==========================
       'J' : begin      //   Jpeg
               wFileName := wFileName + '.jpg';
               Jpeg := TJPEGImage.Create;
               try
                  Jpeg.CompressionQuality := 100;   // Range 1..100
                  with Jpeg do
                  begin            //  Bitmap  JPG
                     Assign(RqImage.Picture.Bitmap);
                     SaveToFile(wFileName);
                  end;
               finally
                     Jpeg.Free;    //   JPG
               end;
             end;
          // ==========================
         'B': begin       //   BMP
                wFileName := wFileName + '.bmp';
                BitMap := TBitMap.Create;
                try
                   with BitMap do   //  Bitmap  BMP
                   begin
                      Assign(RqImage.Picture.Bitmap);
                      SaveToFile(wFileName);
                   end;
                finally
                      BitMap.Free;  //   BMP
                end;
              end;
       end; {of case}
   end;
end; {of procedure ImageToFile}

// --------------------------------------------------------------------
//  Image  
procedure TToViewForm1.ImageClear(RqImage : TImage; RqColor : TColor);
begin
  with RqImage do
  begin
    Canvas.Brush.Color := RqColor;
    Canvas.FillRect(Rect(0,0, Width, Height));
  end;
end;
// ------------------------------------------------------------------------
//   
procedure TToViewForm1.ReShowCalendar();
begin
   ImageClear(Image1, StTxtFon.Color);
   Paint12Month(Image1, IntToStr(GlobRqYear) +  ' ');
end;
// ------------------------------------------------------------------------
//      
procedure TToViewForm1.FormShow(Sender: TObject);
begin
   Image1.Picture.Bitmap.Width   := 900;
   Image1.Picture.Bitmap.Height  := 1420;
   Image1.Width   := Image1.Picture.Bitmap.Width;
   Image1.Height  := Image1.Picture.Bitmap.Height;
   StTxtFDay.Color  := RGB(190,0,0);
   ReShowCalendar();
end;
// ------------------------------------------------------------------------
//      
procedure TToViewForm1.SpButSaveImgClick(Sender: TObject);
begin
  SaveDialog1.Filter := 'JPEG files (*.jpg)|*.JPG';
  if not SaveDialog1.Execute then Exit;
  ImageToFile(Image1, SaveDialog1.FileName, 'J');
end;
// ------------------------------------------------------------------------
//   
procedure TToViewForm1.CmbBoxBoldsClick(Sender: TObject);
begin
   ReShowCalendar();
end;
// ------------------------------------------------------------------------
//      
procedure TToViewForm1.CmbBoxBorderClick(Sender: TObject);
begin
  ReShowCalendar();
end;
// ------------------------------------------------------------------------
//     
procedure TToViewForm1.StTxtWdayClick(Sender: TObject);
begin
   if not ColorDialog1.Execute then Exit;
   StTxtWday.Color := ColorDialog1.Color;
   ReShowCalendar();
end;
// ------------------------------------------------------------------------
//     
procedure TToViewForm1.StTxtFDayClick(Sender: TObject);
begin
   if not  ColorDialog1.Execute then Exit;
   StTxtFDay.Color := ColorDialog1.Color;
   ReShowCalendar();
end;
// ------------------------------------------------------------------------
//     
procedure TToViewForm1.StTxtFonClick(Sender: TObject);
begin
  if not ColorDialog1.Execute then Exit;
  StTxtFon.Color := ColorDialog1.Color;
  ReShowCalendar();
end;
// ------------------------------------------------------------------------
//     
procedure TToViewForm1.StTxtFieldClick(Sender: TObject);
begin
  if not ColorDialog1.Execute then Exit;
  StTxtField.Color := ColorDialog1.Color;
  ReShowCalendar();
end;
// ------------------------------------------------------------------------
//     
procedure TToViewForm1.StTxtTextClick(Sender: TObject);
begin
  if not ColorDialog1.Execute then Exit;
  StTxtText.Color := ColorDialog1.Color;
  ReShowCalendar();
end;
// ------------------------------------------------------------------------
//   
procedure TToViewForm1.SpButUnDoColorsClick(Sender: TObject);
begin
   StTxtFon.Color   := clWindow;
   StTxtField.Color := clWindow;
   StTxtText.Color  := clBtnText;
   StTxtWday.Color  := clBtnText;
   StTxtFDay.Color  := RGB(190,0,0);
   ReShowCalendar();
end;

// ========================================================================
// ========================================================================
end.
