unit ToExcel;
// =========================================================================
//   EXCEL
// =========================================================================
interface

uses SysUtils, Dialogs,
     ComObj,
     MainData;
// =========================================================================
//     Excel
procedure ExportToExcel();

// =========================================================================
// =========================================================================
implementation
// =========================================================================
// =========================================================================

const SrartRow = 4;    //   
      SrartCol = 2;    //   
      MonthRow = 11;   //    
      MonthCol = 8;    //    

//    
const MonthMap : array[1..12] of record
 BRow : integer;
 BCol : integer;
end  =
(
  (BRow : SrartRow;                 BCol : SrartCol),                   // 1
  (BRow : SrartRow;                 BCol : SrartCol + 1 * MonthCol),    // 2
  (BRow : SrartRow;                 BCol : SrartCol + 2 * MonthCol),    // 3
  (BRow : SrartRow + 1 * MonthRow;  BCol : SrartCol),                   // 4
  (BRow : SrartRow + 1 * MonthRow;  BCol : SrartCol + 1 * MonthCol),    // 5
  (BRow : SrartRow + 1 * MonthRow;  BCol : SrartCol + 2 * MonthCol),    // 6
  (BRow : SrartRow + 2 * MonthRow;  BCol : SrartCol),                   // 7
  (BRow : SrartRow + 2 * MonthRow;  BCol : SrartCol + 1 * MonthCol),    // 8
  (BRow : SrartRow + 2 * MonthRow;  BCol : SrartCol + 2 * MonthCol),    // 9
  (BRow : SrartRow + 3 * MonthRow;  BCol : SrartCol),                   // 10
  (BRow : SrartRow + 3 * MonthRow;  BCol : SrartCol + 1 * MonthCol),    // 11
  (BRow : SrartRow + 3 * MonthRow;  BCol : SrartCol + 2 * MonthCol)     // 12
);

// =========================================================================
// ------------------------------------------------------------------------
// 25.11.2014
//      Excel
procedure WriteToExcelSheet(XLApp : Variant);
var Sheet   : Variant;   //    Excel
    wColums : Variant;   //    
    wMonht, BRow, BCol, wIndR, wIndC : Integer;
begin
   //     
   Sheet := XLApp.Workbooks[1].WorkSheets[1];
   //      
   wColums := XLApp.Workbooks[1].WorkSheets[1].Columns;
   //  
   Sheet.Cells[2, 2]:= IntToStr(GlobRqYear) + ' ';
   //       
   for wMonht := 1 to 12
   do begin
     BCol := MonthMap[wMonht].BCol;
     for wIndC :=  Low(TabMonthDay[Low(TabMonthDay)])
               to High(TabMonthDay[Low(TabMonthDay)])
     do begin
       wColums.Columns[BCol + wIndC].ColumnWidth := 4;
       wColums.Columns[BCol + wIndC].HorizontalAlignment := 4;
       wColums.Columns[BCol + wIndC].VerticalAlignment := 2;
     end;
   end;
   //     
   for wMonht := 1 to 12
   do begin
     BRow := MonthMap[wMonht].BRow;
     BCol := MonthMap[wMonht].BCol;
     //  
     Sheet.Cells[BRow, BCol + 1]:= ArrMonthDesc[wMonht].Name;
     //.HorizontalAlignment = xlLeft = 2
     Sheet.Range[Sheet.Cells[BRow, BCol + 1], Sheet.Cells[BRow, BCol + 1]].HorizontalAlignment := 2;
     //     TTabMonthDay  
     MonthToTabMonthDay(wMonht, TabMonthDay);
     //     
     for wIndR := Low(TabMonthDay) to High(TabMonthDay)
     do begin
        for wIndC := Low(TabMonthDay[wIndR]) to High(TabMonthDay[wIndR])
        do begin
           Sheet.Cells[BRow + wIndR, BCol + wIndC]:= TabMonthDay[wIndR, wIndC];
        end;
     end;
     //    
     if NumFormatYear = 1
     then begin
        BRow := SrartRow + 4 * MonthRow;
        BCol := SrartCol;
        Sheet.Cells[BRow, BCol]:= '*  -   ';
        Inc(BRow);
        Sheet.Cells[BRow, BCol]:= '** -    ';
     end;
   end;
end;
// ------------------------------------------------------------------------
// 25.11.2014
//     Excel
procedure ExportToExcel();
const WorkSheetsName = '';
//   OLE unit: ComObj
const xlWorksheet = $FFFFEFB9;  //  (-4167)   
var   XLApp       : Variant;    //   Excel.Application

begin
    try
      //  OLE -   Excel
      XLApp:= CreateOleObject('Excel.Application');
      //  Excel
      XLApp.Visible := True;
      //   
      XLApp.Workbooks.Add(xlWorksheet);
      //    
      XLApp.Workbooks[1].WorkSheets[1].Name := WorkSheetsName;
      //      Excel
      WriteToExcelSheet(XLApp);
    except
      on EOleSysError
      do begin
         MessageDlg('   EXCEL'
                    + #13#10
                    + 'Win-API : ' + SysErrorMessage(GetLastError)
                    + #13#10 + '  EXCEL '
                    + #13#10 + '    ...',
                    mtWarning, [mbOk], 0);
      end;
      on E1: EOleError
      do begin
         MessageDlg('    EXCEL'
                    + #13#10
                    + 'Excel : ' + E1.Message
                    + #13#10
                    + 'Win-API : ' + SysErrorMessage(GetLastError),
                    mtWarning, [mbOk], 0);
      end;
      // .  : EOleSysError, EOleError, EOleException
    end;
end;
// =========================================================================
// =========================================================================
// =========================================================================

end.
