unit MainData;

interface

// ========================================================================
// ------------------------------------------------------------------------
// 14.11.2014     
// ------------------------------------------------------------------------
//
var GlobRqYear   : integer;     //  
    GlobRqMonth  : integer;     //  
    CurrentYear  : integer;     //  
    CurrentMonth : integer;     //  
    CurrentDay   : Integer;     //  
// ------------------------------------------------------------------------
// 17.11.2014     
// ------------------------------------------------------------------------
// 15.08.2019
var ApplicationDir : string;   //  
var IniFileName    : string;   //     
// ------------------------------------------------------------------------
//    
const WeakDayName : array [1..7]
                    of string[2] = ('','','', '','','', '');
// ------------------------------------------------------------------------
//   
type TMonthDesc = record
   Name     : string;   //  
   DayCount : integer;  //    
end;

//     
const ArrMonthDesc : array [1..12] of TMonthDesc =
 ((Name:'01 (  / Ѳ )';      DayCount : 31),
  (Name:'02 (  /  )';      DayCount : 28),
  (Name:'03 (  /  )';      DayCount : 31),
  (Name:'04 (  / ² )';     DayCount : 30),
  (Name:'05 (  /  )';        DayCount : 31),
  (Name:'06 (  /  )';       DayCount : 30),
  (Name:'07 (  /  )';        DayCount : 31),
  (Name:'08 (  /  )';     DayCount : 31),
  (Name:'09 (  /  )';  DayCount : 30),
  (Name:'10 (  /  )';    DayCount : 31),
  (Name:'11 (  /  )';    DayCount : 30 ),
  (Name:'12 (  /  )';    DayCount : 31 ));
// ------------------------------------------------------------------------
//      
type TOneDay = record
  DayInYear   : integer;   //    
  MonthNum    : integer;   //    
  DayInMonth  : integer;   //   MonthNum
  DayInWeek   : integer;   //      DayInMonth
  flgHoliday  : boolean;   //  -  
  flgEndWeek  : boolean;   //  -   
  WeekInYear  : integer;   //     
  WeekInTerm  : integer;   //    
  TeahWeek    : integer;   //   
end;

//      
type TpOneDay = ^TOneDay;

//     
type TArrYear = array of array of TOneDay;

//     
var ArrYear : TArrYear;
// ------------------------------------------------------------------------
//      
const TabRowNum = 9;    // Min    = 7
      TabColNum = 7;    //  = 7
type  TTabMonthDay = array[1..TabRowNum, 1..TabColNum] of string[2];

//     
var   TabMonthDay : TTabMonthDay;
// ------------------------------------------------------------------------
//        
type TSemestr = record
  sBegDayNum  : integer;    //    
  sBegMonth   : integer;    //   
  sLenWeek    : integer;    //    
  sBegWeek    : integer;    //    
  //   (  .ini)
  sLenWeekInd : integer;    //  ComdoBox    
  sBegWeekInd : integer;    //  ComdoBox    
  //     
  sFlgTerm    : boolean;    //    
  sFlgRun     : boolean;    //  -   
  sRestWeek   : integer;    //      
  sTeahWeek   : integer;    //     
end;

//      
var Semestr1 : TSemestr;  //    
    Semestr2 : TSemestr;  //    
// ------------------------------------------------------------------------
//   
var NumFormatGrid : integer; //      Grid
    NumFormatYear : integer; //    
// ========================================================================
//   NOTE
const NoteMarkup =' #';
//    Note
var NoteDay      : string;
    NoteMonth    : string;
    NoteYear     : string;
    NoteFileName : string;
//   Note
var NoteOK       : boolean;

// ========================================================================
// ------------------------------------------------------------------------
//     TTabMonthDay  
procedure MonthToTabMonthDay(RqMonthNum : integer; var TabMD : TTabMonthDay);

// ========================================================================
// ========================================================================
implementation
// ========================================================================
// ========================================================================
uses SysUtils;
// ------------------------------------------------------------------------
// 14.11.2014
//     TTabMonthDay  
procedure MonthToTabMonthDay(RqMonthNum : integer; var TabMD : TTabMonthDay);
//    TStringGrid  
const MonthTabFormat : array [1..7]
  of record
    Day : integer;  //   
    Row : integer;  //    RqTabMD
  end =
(
(Day : 1; Row :7),  // 
(Day : 2; Row :1),  // 
(Day : 3; Row :2),  // 
(Day : 4; Row :3),  // 
(Day : 5; Row :4),  // 
(Day : 6; Row :5),  // 
(Day : 7; Row :6)   // 
);
var wInd, wDay, wRow, wCol, wI : integer;
begin
   //   
   for wRow := Low(TabMD) to High(TabMD)
   do for wCol := Low(TabMD[wRow]) to High(TabMD[wRow])
      do TabMD[wRow, wCol] := ' ';
   //   
   if (RqMonthNum < 1) or (RqMonthNum > 12) then Exit;
   //    (  )
   for wDay := 1 to 7
   do begin
      wRow := MonthTabFormat[wDay].Row;
      TabMD[wRow, 1] := WeakDayName[wDay];
   end;
   //     
   wCol  := 2;
   for wInd := Low(ArrYear[RqMonthNum-1]) to High(ArrYear[RqMonthNum-1])
   do begin
      wDay := ArrYear[RqMonthNum-1,wInd].DayInWeek;
      wRow := MonthTabFormat[wDay].Row;
      //     
      TabMD[wRow, wCol] := IntToStr(ArrYear[RqMonthNum-1,wInd].DayInMonth);
      //  
      if wRow >= 7 then wCol := wCol + 1;
   end;
   // ----------------------
   //  
   // ----------------------
   //    
   if NumFormatYear > 0
   then begin
      wCol := 2; wI := 0;
      for wInd := 0 to High(ArrYear[RqMonthNum-1])
      do begin
         if ArrYear[RqMonthNum-1, wInd].WeekInTerm > 0
         then begin
           if wI <> ArrYear[RqMonthNum-1, wInd].WeekInYear
           then begin
              wI := ArrYear[RqMonthNum-1, wInd].WeekInYear;
              //  
              wRow := 8;
              TabMD[wRow, 1] := '*';   //   
              TabMD[wRow, wCol] := IntToStr(ArrYear[RqMonthNum-1,wInd].TeahWeek);
              Inc(wRow);
              TabMD[wRow, 1] := '**';  //    
              TabMD[wRow, wCol] := IntToStr(ArrYear[RqMonthNum-1,wInd].WeekInTerm);
           end;
         end;
         if ArrYear[RqMonthNum-1,wInd].flgEndWeek then wCol := wCol + 1;
      end;
   end;   
end;
// ========================================================================
// ========================================================================

end.
