unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  StrUtils, Dialogs, Grids, StdCtrls, ExtCtrls, DateUtils, Printers, ComCtrls,
  Buttons, Menus,
  MainData, AnalogClock, ToView, ToExcel, UnitNote;

type
  TForm1 = class(TForm)
    EdYear: TEdit;
    Label1: TLabel;
    LbDateNow: TLabel;
    Timer1: TTimer;
    stxtDateNow: TStaticText;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    StringGrid1: TStringGrid;
    CmbBoxRqMonth: TComboBox;
    Panel1: TPanel;
    Label2: TLabel;
    EdSem1BDay: TEdit;
    Label3: TLabel;
    EdSem1BMonth: TEdit;
    Label4: TLabel;
    CmbBoxSem1LMonth: TComboBox;
    Label5: TLabel;
    CmbBoxSem1BWeek: TComboBox;
    Panel2: TPanel;
    Label8: TLabel;
    EdSem2BDay: TEdit;
    Label9: TLabel;
    EdSem2BMonth: TEdit;
    Label6: TLabel;
    CmbBoxSem2LMonth: TComboBox;
    Label7: TLabel;
    CmbBoxSem2BWeek: TComboBox;
    Label11: TLabel;
    Label10: TLabel;
    Label12: TLabel;
    Image1: TImage;
    RdButShow1: TRadioButton;
    RdButShow2: TRadioButton;
    RdButShow3: TRadioButton;
    PrintDialog1: TPrintDialog;
    SpdButSaveIni: TSpeedButton;
    Label13: TLabel;
    TabSheet4: TTabSheet;
    SpeedButton1: TSpeedButton;
    Label15: TLabel;
    Label16: TLabel;
    Panel3: TPanel;
    RdButPrint1: TRadioButton;
    RdButPrint2: TRadioButton;
    Label17: TLabel;
    Label18: TLabel;
    SpButExcel: TSpeedButton;
    Label19: TLabel;
    Panel4: TPanel;
    Label14: TLabel;
    SpdButPrintYear: TSpeedButton;
    CmbBoxPrintStyle: TComboBox;
    Label20: TLabel;
    PopupMenuNotes: TPopupMenu;
    PUMenuDelete: TMenuItem;
    PUMenuOpen: TMenuItem;
    PUMenuSep: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure CmbBoxRqMonthClick(Sender: TObject);
    procedure EdYearChange(Sender: TObject);
    procedure RdButShow3Click(Sender: TObject);
    procedure RdButShow2Click(Sender: TObject);
    procedure RdButShow1Click(Sender: TObject);
    procedure SpdButSaveIniClick(Sender: TObject);
    procedure SpdButPrintYearClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpButExcelClick(Sender: TObject);
    procedure PUMenuOpenClick(Sender: TObject);
    procedure PUMenuDeleteClick(Sender: TObject);
  private
    { Private declarations }
     //        
     procedure PrepareRequests();
     //       'calendar.ini'
     procedure LoadSemestrsParm();

  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}


// ========================================================================
//  
// ========================================================================
// ------------------------------------------------------------------------
// // 17.11.2014
//    ini 
function GetIniFileName() : string;
var WInt : integer;
    WStr : string;
begin
   //      
   WStr := Application.ExeName;
   //    '.EXE' ( )
   WInt := PosEx('.EXE',UpperCase(WStr));
   //       
   Result := LeftStr(WStr, WInt) + 'ini';
end;
// ------------------------------------------------------------------------
//  Edit.Text  
function EditToInt (RqEdit : TEdit; var Val : integer) : boolean;
var WInt : integer;
begin
  Result := False;     //   
  try
    WInt := StrToInt(RqEdit.Text);
    Val  := WInt;
    RqEdit.Color := clWindow;
    Result := True;    //   
  except
    RqEdit.Color := RGB(240,127,127);
    ShowMessage('    ');
  end;
end;
// ========================================================================
//       
// ========================================================================
// ------------------------------------------------------------------------
// 16.11.2014
//      
procedure AddPrepareOneDay (pOneDay : TpOneDay; var RqSemestr : TSemestr);
begin
  with pOneDay^, RqSemestr
  do begin
       //    
       if (sBegDayNum = DayInMonth) and
          (sBegMonth  = MonthNum)
       then begin
           sRestWeek := sLenWeek;
           sFlgTerm   := True;   //   
           sFlgRun    := False;
       end;
       // ,   ,    
       if sFlgTerm and (not flgHoliday)
       then begin
           sFlgTerm   := False;
           sFlgRun    := True;    //    
           sTeahWeek  := sBegWeek;
       end;
       if sFlgRun
       then begin
           //     
           WeekInTerm := sLenWeek + 1 - sRestWeek;
           if flgEndWeek then Dec(sRestWeek);
           //    (  )
           TeahWeek := sTeahWeek;
           if flgEndWeek
           then begin
               Inc(sTeahWeek);
               if sTeahWeek  > 2 then sTeahWeek := 1;
           end;
           //    
           if (sRestWeek <= 0) then sFlgRun := False;
       end;
  end;
end;

// ------------------------------------------------------------------------
// 14.11.2014
//       
//    PrepareYear
procedure CalcArrYear(LeapYear     : boolean;   //   
                      StartWeekNum : integer;   //     
                      var ArrYear  : TArrYear); //   
//  
var pOneDay : TpOneDay;  //     
    wYearDay,            //      
    wYearWeek,           //      
    wDayInWeek,          //      
    wMInd,               //     ArrYear
    wDInd : integer;     //      ArrYear
begin
   //    
   wYearDay  := 1;
   wYearWeek := 1;
   wDayInWeek := StartWeekNum;
   //       
   SetLength(ArrYear, 12);
   for wMInd := Low(ArrYear) to High(ArrYear)
   do begin
      wDInd := ArrMonthDesc[wMInd + 1].DayCount;
      if (wMInd = 1) and LeapYear then wDInd := wDInd + 1;
      SetLength(ArrYear[wMInd], wDInd);
      for wDInd := Low(ArrYear[wMInd]) to High(ArrYear[wMInd])
      do begin
          //     
          FillChar(ArrYear[wMInd,wDInd], SizeOf(TOneDay), #0);
          //      
          pOneDay := Addr(ArrYear[wMInd,wDInd]);
          //     
          with ArrYear[wMInd,wDInd]
          do begin
              // ----------------------------
              //    
              DayInYear  := wYearDay;
              MonthNum   := wMInd + 1;
              DayInMonth := wDInd + 1;
              DayInWeek  := wDayInWeek;
              //    
              if (DayInWeek = 1) or (DayInWeek = 7)  // , 
              then flgHoliday := True
              else flgHoliday := False;
              //    
              if DayInWeek = 1  // 
              then flgEndWeek := True
              else flgEndWeek := False;
              //      
              WeekInYear := wYearWeek;
              if flgEndWeek then wYearWeek := wYearWeek + 1;
              // ----------------------------
              //     
              AddPrepareOneDay (pOneDay, Semestr2);
              AddPrepareOneDay (pOneDay, Semestr1);
          end;
          //    
          wYearDay := wYearDay + 1;
          //    
          if wDayInWeek + 1 > 7
          then wDayInWeek := 1
          else wDayInWeek := wDayInWeek + 1;
      end;
   end;
end;

// ------------------------------------------------------------------------
// 14.11.2014
//        
procedure PrepareYear(RqYear : integer);   //  
//  
var LeapYear     : boolean;   //   
    StartWeekNum : integer;   //     
    wBaseYear    : integer;   //    
begin
 //   
 if RqYear < 1582
 then begin
   MessageDlg('   '
   + #13#10 + '   1582 .',
     mtInformation, [mbOk], 0);
   Exit;
 end;
 //   " "
 LeapYear := False;
 if (RqYear mod 4) = 0 then LeapYear := True;

 //    
 //      
 wBaseYear := 1;
 //      28 
 //  ,     
 while wBaseYear < RqYear do wBaseYear := wBaseYear + 2 * 28;
 if wBaseYear > RqYear then  wBaseYear := wBaseYear - 2 * 28;

 //        
 //        1
 //        2
 StartWeekNum := 1;   // 
 while wBaseYear < RqYear
 do begin
    if (wBaseYear mod 4) = 0
    then StartWeekNum := StartWeekNum + 2
    else StartWeekNum := StartWeekNum + 1;

    if StartWeekNum > 7
    then StartWeekNum := StartWeekNum mod 7;
    wBaseYear := wBaseYear + 1;
 end;
 //    
 CalcArrYear(LeapYear, StartWeekNum, ArrYear);
end;
// ========================================================================
//     
// ========================================================================
// ------------------------------------------------------------------------
// 13.10.2014
//   TStringGrid
procedure ClearStringGrid (RqSG : TStringGrid);
var wCol, wRow : integer;
begin
   for wCol := 0 to RqSG.ColCount -1
   do for wRow := 0 to RqSG.RowCount - 1
      do RqSG.Cells[wCol, wRow] := '';
end;

// ------------------------------------------------------------------------
// 14.11.2014
//        TStringGrid
procedure MonthToGrid(RqGrid : TStringGrid; RqMonth : integer);
//    TStringGrid  
const MonthTabFormat : array [1..7]
  of record
    Day : integer;  //   
    Row : integer;  //    TStringGrid
  end =
(
(Day : 1; Row :7),  // 
(Day : 2; Row :1),  // 
(Day : 3; Row :2),  // 
(Day : 4; Row :3),  // 
(Day : 5; Row :4),  // 
(Day : 6; Row :5),  // 
(Day : 7; Row :6)   // 
);
var wInd, wDay, wRow, wCol, wI : integer;
    wSelectDay : Boolean; wSelectRow, wSelectCol : integer;
    wDayStr    : string;
begin
   //      Grid
   wSelectDay := (CurrentYear = GlobRqYear) and (CurrentMonth = GlobRqMonth);
   //   Grid
   wSelectRow := RqGrid.RowCount - 1;;
   wSelectCol := RqGrid.ColCount - 1;;
   //   
   ClearStringGrid(RqGrid);
   //    (  )
   for wDay := 1 to 7
   do begin
      wRow := MonthTabFormat[wDay].Row;
      RqGrid.Cells[0 ,wRow] := WeakDayName[wDay];
      RqGrid.Cells[0 ,0] := '\';
   end;
   //     
   wCol  := 1;
   for wInd := 0 to High(ArrYear[RqMonth-1])
   do begin
      wDay := ArrYear[RqMonth-1,wInd].DayInWeek;
      wRow := MonthTabFormat[wDay].Row;
      //    
      wDayStr      := IntToStr(ArrYear[RqMonth-1,wInd].DayInMonth);
      NoteDay      := wDayStr;
      NoteMonth    := IntToStr(GlobRqMonth);
      NoteYear     := IntToStr(GlobRqYear);
      NoteFileName := ApplicationDir + '\NOTEs\'
                   + NoteYear  + '-'
                   + NoteMonth + '-'
                   + NoteDay + '.txt';
      //           
      if FileExists(NoteFileName)
      then RqGrid.Cells[wCol, wRow] := wDayStr + NoteMarkup
      else RqGrid.Cells[wCol, wRow] := wDayStr;
      if wSelectDay and (ArrYear[RqMonth-1,wInd].DayInMonth = CurrentDay)
      then begin
        wSelectRow := wRow;
        wSelectCol := wCol;
      end;
      //  
      if wRow >= 7 then wCol := wCol + 1;
   end;
   // ----------------------
   //  
   // ----------------------
   //      
   if NumFormatGrid = 1
   then begin
      wCol := 1; wI := 0;
      for wInd := 0 to High(ArrYear[RqMonth-1])
      do begin
         if wI <> ArrYear[RqMonth-1, wInd].WeekInYear
         then begin
            wI := ArrYear[RqMonth-1, wInd].WeekInYear;
            RqGrid.Cells[wCol, 0] := IntToStr(ArrYear[RqMonth-1, wInd].WeekInYear);
         end;
         if ArrYear[RqMonth-1,wInd].DayInWeek = 1 then wCol := wCol + 1;
      end;
   end;
   //     
   if (NumFormatGrid = 2) or (NumFormatGrid = 3)
   then begin
      wCol := 1; wI := 0;
      for wInd := 0 to High(ArrYear[RqMonth-1])
      do begin
         if ArrYear[RqMonth-1, wInd].WeekInTerm > 0
         then begin
           if wI <> ArrYear[RqMonth-1, wInd].WeekInYear
           then begin
              wI := ArrYear[RqMonth-1, wInd].WeekInYear;
              //      
              if NumFormatGrid = 2
              then RqGrid.Cells[wCol, 0] := IntToStr(ArrYear[RqMonth-1, wInd].WeekInTerm);
              //     
              if NumFormatGrid = 3
              then RqGrid.Cells[wCol, 0] := IntToStr(ArrYear[RqMonth-1, wInd].TeahWeek);
           end;
         end;
         if ArrYear[RqMonth-1,wInd].flgEndWeek then wCol := wCol + 1;
      end;
   end;
   //   Grid
   RqGrid.Col := wSelectCol;
   RqGrid.Row := wSelectRow;
   RqGrid.Refresh;
end;
// ------------------------------------------------------------------------
//      
procedure TForm1.RdButShow3Click(Sender: TObject);
begin
  NumFormatGrid := 3;
  MonthToGrid(StringGrid1, GlobRqMonth);
end;
// ------------------------------------------------------------------------
//        
procedure TForm1.RdButShow2Click(Sender: TObject);
begin
  NumFormatGrid := 2;
  MonthToGrid(StringGrid1, GlobRqMonth);
end;
// ------------------------------------------------------------------------
//        
procedure TForm1.RdButShow1Click(Sender: TObject);
begin
  NumFormatGrid := 1;
  MonthToGrid(StringGrid1, GlobRqMonth);
end;
// ========================================================================
//   12   
// ========================================================================
// ------------------------------------------------------------------------
// 17.11.2014
//      
procedure PrintMonth (PrintStyle, StartX, StartY,
                      MonthNum : integer; MonthName : string;
                      var XEnd, YEnd : integer);
var BegX, BegY    : integer;
    ChW,  ChH     : integer;
    wRow, wCol    : integer;
    wStr          : string;
    X1,Y1,X2,Y2   : integer;
begin
  with Printer do
  begin
     ChW := Canvas.TextWidth('1234');
     ChH := Canvas.TextHeight('1') + 20;
     BegX := StartX;
     BegY := StartY;
     // 
     Canvas.TextOut(BegX, BegY, MonthName);
     // 
     BegY := BegY + ChH + 20;
     for wRow := Low(TabMonthDay) to High(TabMonthDay)
     do begin
        BegX := StartX;
        for wCol := Low(TabMonthDay[wRow]) to High(TabMonthDay[wRow])
        do begin
           //  
           X1 := BegX;
           Y1 := BegY;
           X2 := BegX + ChW;
           Y2 := BegY + ChH;
           case PrintStyle of
             1 : Canvas.Rectangle(X1,Y1,X2,Y2);
             2 : Canvas.Rectangle(X1,Y1,X2-16,Y2-16);
           end;
           //   
           wStr := TabMonthDay[wRow, wCol];
           Canvas.TextOut(BegX + (ChW div 4), BegY + 10, wStr);
           BegX := BegX + ChW;
        end;
        BegY := BegY + ChH;
     end;
     XEnd := BegX;
     YEnd := BegY;
  end;
end;

// ------------------------------------------------------------------------
// 17.11.2014
//      (: 3col * 4row  A4)
procedure Print12Month(PrintStyle : integer; RqYearTxt : string);
const BorderY = 400; //   
      BorderX = 400; //   
var IndRow        : integer;
    IndCol        : integer;
    Ind           : integer;
    PageX, PageY  : integer;
    BegX, BegY    : integer;
    XEnd, YEnd    : integer;
    wStr : string;
begin
  //   12 
  with Printer do
     begin
     //  
     Canvas.Font.Name := 'MS Sans Serif';
     Canvas.Font.Size := 14;
     Canvas.Pen.Width := 8;
     Canvas.Brush.Style := bsClear;
     PageX := BorderX;
     PageY := BorderY;
     BeginDoc;
     BegY   := PageY;
     wStr := RqYearTxt; // 
     //  
     BegX := Canvas.TextWidth(wStr) div 2;
     BegX := (PageWidth div 2) - BegX;
     //  
     Canvas.TextOut(BegX, BegY, wStr);
     BegY := BegY + 2 * Canvas.TextHeight(wStr);
     //      
      Canvas.Font.Size := 10;
      XEnd   := 0;
      YEnd   := 0;
      for IndRow := 1 to 4
      do begin
         BegX := PageX;
         for IndCol := 1 to 3
         do begin
           Ind := 3 * (IndRow - 1) + IndCol;
           //   
           MonthToTabMonthDay(Ind, TabMonthDay);
           //   
           PrintMonth (PrintStyle, BegX, BegY, 0,
                       ArrMonthDesc[Ind].Name, XEnd, YEnd);
           BegX := XEnd + 100;
         end;
         BegY := YEnd + 100;
      end;
      //  
      if NumFormatYear = 1
      then begin
         BegY := YEnd + 100;
         Canvas.TextOut(PageX, BegY, '*  -   ');
         BegY := BegY + Canvas.TextHeight('1') + 40;;
         Canvas.TextOut(PageX, BegY, '** -    ');
      end;
     EndDoc;
  end;
end;

// ------------------------------------------------------------------------
//     
procedure TForm1.SpdButPrintYearClick(Sender: TObject);
var PrintStyle : integer;
begin
   //        
   NumFormatYear := 0;
   if RdButPrint2.Checked then NumFormatYear := 1;
   //  
   if not PrintDialog1.Execute then Exit;
   //   12 
   PrintStyle := CmbBoxPrintStyle.ItemIndex;
   Print12Month(PrintStyle, EdYear.Text +  ' ');
end;

// ========================================================================
//      
// ========================================================================
// ------------------------------------------------------------------------
// 17.11.2014
//        
procedure TForm1.PrepareRequests();
var wInt1, wInt2 : integer;
begin
   //     
   FillChar(Semestr1, SizeOf(Semestr1), #0);
   if EditToInt(EdSem1BDay, wInt1) and EditToInt(EdSem1BMonth, wInt2)
   then begin
      with Semestr1 do
      begin
          sBegDayNum  := wInt1;
          sBegMonth   := wInt2;
          //  ComdoBox    
          sLenWeekInd := CmbBoxSem1LMonth.ItemIndex;
          case sLenWeekInd of
            0 : sLenWeek := 17;
            1 : sLenWeek := 18;
            2 : sLenWeek := 19;
          end;
          //  ComdoBox    
          sBegWeekInd := CmbBoxSem1BWeek.ItemIndex;
          case sBegWeekInd of
            0 : sBegWeek := 1;
            1 : sBegWeek := 2;
          end;
      end;
   end;
   //     
   FillChar(Semestr2, SizeOf(Semestr2), #0);
   if EditToInt(EdSem2BDay, wInt1) and EditToInt(EdSem2BMonth, wInt2)
   then begin
      with Semestr2 do
      begin
          sBegDayNum := wInt1;
          sBegMonth  := wInt2;
          //  ComdoBox    
          sLenWeekInd := CmbBoxSem2LMonth.ItemIndex;
          case sLenWeekInd of
            0 : sLenWeek := 17;
            1 : sLenWeek := 18;
            2 : sLenWeek := 19;
          end;
          //  ComdoBox    
          sBegWeekInd := CmbBoxSem2BWeek.ItemIndex;
          case sBegWeekInd of
            0 : sBegWeek := 1;
            1 : sBegWeek := 2;
          end;
      end;
   end;
end;

// ------------------------------------------------------------------------
// 17.11.2014
//       'calendar.ini'   
procedure TForm1.LoadSemestrsParm();
var List  : TStringList;
begin
  if FileExists(IniFileName)
  then begin
     List := TStringList.Create;
     try
        List.LoadFromFile(IniFileName);
        if List.Count = 8
        then begin
            with Semestr1
            do begin
               EdSem1BDay.Text   := Trim(List.Strings[0]);
               EdSem1BMonth.Text := Trim(List.Strings[1]);
               CmbBoxSem1LMonth.ItemIndex := StrToInt(Trim(List.Strings[2]));
               CmbBoxSem1BWeek.ItemIndex  := StrToInt(Trim(List.Strings[3]));
            end;
            with Semestr2
            do begin
               EdSem2BDay.Text   := Trim(List.Strings[4]);
               EdSem2BMonth.Text := Trim(List.Strings[5]);
               CmbBoxSem2LMonth.ItemIndex := StrToInt(Trim(List.Strings[6]));
               CmbBoxSem2BWeek.ItemIndex  := StrToInt(Trim(List.Strings[7]));
            end;
        end;
     except
        PageControl1.ActivePage := TabSheet3;
        MessageDlg('      :'
                     + #13#10 + IniFileName
                     + #13#10 + '    .',
                     mtWarning, [mbOk], 0);
     end;
     List.Free;
  end;
  //        
  PrepareRequests();
end;

// ------------------------------------------------------------------------
// 17.11.2014
//      
procedure SemestrsToList (RqList : TStringList; RqSemestr : TSemestr);
begin
    //  Edit
    RqList.Add(IntToStr(RqSemestr.sBegDayNum));
    RqList.Add(IntToStr(RqSemestr.sBegMonth));
    //  ComboBox
    RqList.Add(IntToStr(RqSemestr.sLenWeekInd));
    RqList.Add(IntToStr(RqSemestr.sBegWeekInd));
end;

// ------------------------------------------------------------------------
// 17.11.2014
//      'calendar.ini'
procedure TForm1.SpdButSaveIniClick(Sender: TObject);
var List : TStringList;
begin
   //        
   PrepareRequests();
   List := TStringList.Create;
     SemestrsToList (List, Semestr1);
     SemestrsToList (List, Semestr2);
     try
      //       'calendar.ini'
      List.SaveToFile(IniFileName);
      //       'calendar.ini'
      LoadSemestrsParm();
      MessageDlg('  .',
          mtInformation, [mbOk], 0);
      except
         MessageDlg('    :'
                     + #13#10 + IniFileName,
                     mtError, [mbOk], 0);
      end;
   List.Free;
end;

// ========================================================================
//    
// ========================================================================
// ------------------------------------------------------------------------
procedure CalcAndShowNewYear(Year, Month : integer; RqGrid : TStringGrid);
begin
    ClearStringGrid(RqGrid);
    if (Month < 1) or (Month > 12)
    then begin
      ShowMessage('      1..12');
      Exit;
    end;
    // ------------------------------------------
    //    
    PrepareYear(Year);
    //      
    NumFormatGrid := 3;
    //  
    MonthToGrid(RqGrid, Month);
end;

// ------------------------------------------------------------------------
procedure TForm1.FormCreate(Sender: TObject);
var Ind : integer;
    DateTime : TDateTime;
    wYear, wMonth, wDay, wDayOfWeek: Word;
begin
  ApplicationDir := Application.ExeName;
  ApplicationDir := ExtractFileDir(ApplicationDir);
  Application.ShowHint := True;
  //   
  DateTime := Now();
  DecodeDateFully(DateTime, wYear, wMonth, wDay, wDayOfWeek);
  //   
  CurrentYear := wYear;
  GlobRqYear  := CurrentYear;
  //   
  if (GlobRqYear mod 4) = 0
  then Label1.Visible := True
  else Label1.Visible := False;
  //      
  CurrentMonth := wMonth;
  GlobRqMonth  := CurrentMonth;
  CurrentDay   := wDay;
  //   
  CmbBoxRqMonth.Clear;
  for Ind := Low(ArrMonthDesc) to High(ArrMonthDesc)
  do CmbBoxRqMonth.Items.Add(ArrMonthDesc[Ind].Name);
  CmbBoxRqMonth.ItemIndex := GlobRqMonth - 1;
  CmbBoxRqMonth.OnClick := CmbBoxRqMonthClick;
  //   
  EdYear.Text := IntToStr(GlobRqYear);
  EdYear.OnChange := EdYearChange;
  //     
  IniFileName := GetIniFileName();
  //       'calendar.ini'
  LoadSemestrsParm();
  //      
  CalcAndShowNewYear(wYear, wMonth, StringGrid1);
  //   
   InitShowDateTime(Image1, TabSheet2.Width, TabSheet2.Height);
end;

// ------------------------------------------------------------------------
procedure TForm1.CmbBoxRqMonthClick(Sender: TObject);
begin
   GlobRqMonth := CmbBoxRqMonth.ItemIndex + 1;
   // ------------------------------------------
   ClearStringGrid(StringGrid1);
   MonthToGrid(StringGrid1, GlobRqMonth);
end;
// ------------------------------------------------------------------------
procedure TForm1.EdYearChange(Sender: TObject);
begin
   if EditToInt(EdYear, GlobRqYear)
   then begin
     //   
     if (GlobRqYear mod 4) = 0
     then Label1.Visible := True
     else Label1.Visible := False;
     //        
     PrepareRequests();
     //      
     CalcAndShowNewYear(GlobRqYear, GlobRqMonth, StringGrid1);
   end;
end;
// ------------------------------------------------------------------------
//    
procedure TForm1.Timer1Timer(Sender: TObject);
var wDateTime : TDateTime;
    wYear, wMonth, wDay, wDayOfWeek: Word;
begin
   wDateTime := Now();
   DecodeDateFully(wDateTime, wYear, wMonth, wDay, wDayOfWeek);
   stxtDateNow.Caption := WeakDayName[wDayOfWeek] + '. ' + DateToStr(wDateTime);
   //      
   ShowDateTime (Image1);
end;
// ------------------------------------------------------------------------
//    
// ------------------------------------------------------------------------
//    Image
procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
   //       
   NumFormatYear := 0;
   if RdButPrint2.Checked then NumFormatYear := 1;
   ToViewForm1.ShowModal;
end;

// ------------------------------------------------------------------------
//    Image
procedure TForm1.SpButExcelClick(Sender: TObject);
begin
   //       
   NumFormatYear := 0;
   if RdButPrint2.Checked then NumFormatYear := 1;
   //    Excel
   ExportToExcel();
end;

// ========================================================================
//     
// ========================================================================
// ------------------------------------------------------------------------
//   Note -     
//    
function BuildNoteFileName(Grid : TStringGrid; DayFromGrid : string) : boolean;
begin
  with Grid do
  begin
    Result := False;
    if RightStr(NoteDay, 1)= RightStr(NoteMarkup, 1)
    then begin
        NoteDay := Copy(NoteDay, 1, Length(NoteDay) - Length(NoteMarkup));
        Result  := True;  //    NoteMarkup
    end;
    NoteMonth    := IntToStr(GlobRqMonth);
    NoteYear     := IntToStr(GlobRqYear);
    NoteFileName := ApplicationDir + '\NOTEs\'
                  + NoteYear  + '-'
                  + NoteMonth + '-'
                  + NoteDay + '.txt';
  end;
end;
// ------------------------------------------------------------------------
//         
procedure TForm1.PUMenuOpenClick(Sender: TObject);
var Markup : boolean;
begin
  with StringGrid1 do
  begin
    NoteDay := Cells[Col, Row];
    if NoteDay = '' then Exit;
    //     
    Markup := BuildNoteFileName(StringGrid1, NoteDay);
    //   
    FormNote.ShowModal;
    //  
    if NoteOK
    then begin
        //   
        if not Markup then Cells[Col, Row] := NoteDay + NoteMarkup;
    end
    else //   
         Cells[Col, Row] := NoteDay;
  end;
end;
// ------------------------------------------------------------------------
//      
//    
procedure TForm1.PUMenuDeleteClick(Sender: TObject);
begin
  with StringGrid1 do
  begin
    NoteDay := Cells[Col, Row];
    if NoteDay = '' then Exit;
    //     
    BuildNoteFileName(StringGrid1, NoteDay);
    if MessageDlg('   :'
        + #13#10 + NoteFileName
        + #13#10 + '?',
        mtConfirmation, [mbYes, mbNo], 0) = mrYes
    then begin
       //   
       if FileExists(NoteFileName)
       then DeleteFile(NoteFileName);
       Cells[Col, Row] := NoteDay;
    end;
  end;
end;

// ========================================================================
//                       
// ========================================================================


end.
