unit AnalogClock;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs, ExtCtrls, DateUtils;
// ========================================================================
//   
procedure  InitShowDateTime (RqImage : TImage; RqW, RqH : integer);

//      
procedure  ShowDateTime (RqImage : TImage);
// ========================================================================
// ========================================================================
implementation
// ========================================================================
// ========================================================================
const DigitDR   = 50;
      PointDR   = DigitDR + 10;

// ------------------------------------------------------------------------
//  RqImage   
procedure ClearImage (RqImage : TImage);
var R : TRect;
begin
  R  := Rect(0,0, RqImage.Width,RqImage.Height);
  with RqImage.Canvas
  do begin
    Brush.Style := bsSolid;
    //    
    Brush.Color := RqImage.Parent.Brush.Color;
    Pen.Style := psClear;
    FillRect(R);
  end;
end;
// ------------------------------------------------------------------------
//  ,  .
procedure ShowCircle (RqImage : TImage; X,Y,Radius : integer; RqColor : TColor);
var R : TRect;
begin
   R  := Rect(X - Radius, Y - Radius, X + Radius, Y + Radius);
   with RqImage.Canvas
   do begin
     Brush.Style := bsSolid;
     Brush.Color := RqColor;
     Pen.Mode := pmCopy;
     Pen.Style := psClear;
     RqImage.Canvas.Ellipse(R);
   end;
end;
// ------------------------------------------------------------------------
//       ( )
//      X, Y
procedure AngleRadiusToXY (RqAngle, RqRadius : integer; var X,Y : integer);
begin
  X := Trunc(RqRadius * Cos(RqAngle * 2 * Pi / 360));
  Y := Trunc(RqRadius * Sin(RqAngle * 2 * Pi / 360));
end;

//     
procedure ShowHourDigits (RqImage : TImage; X, Y, Radius : integer);
const HT : array [0..11] of string =
          ('3','2','1','12','11','10','9','8','7','6','5','4');
var Ind    : integer;
    XE, YE : integer;
begin
   //     
   for Ind := 0 to 59
   do begin
     AngleRadiusToXY ((360 div 60) * Ind, Radius - 4, XE, YE);
     ShowCircle (RqImage, X + XE, Y - YE, 2, clWhite);
   end;
   //   
   for Ind := 0 to 11
   do begin
     //    
     AngleRadiusToXY ((360 div 12) * Ind, Radius - 4, XE, YE);
     ShowCircle (RqImage, X + XE, Y - YE, 4, clWhite);
   end;
   //    
   with RqImage.Canvas
   do begin
     Brush.Style := bsClear;
     Font.Size := 9;
     Font.Style := [fsBold];
     Font.Color := clBlack;
     for Ind := 0 to 11
     do begin
       //    
       AngleRadiusToXY ((360 div 12) * Ind,
                        Radius + TextHeight('0'),
                        XE, YE);
       TextOut(X + XE - TextWidth (HT[Ind]) div 2,
               Y - YE - TextHeight(HT[Ind]) div 2,
               HT[Ind]);
     end;
   end;
end;
// ------------------------------------------------------------------------
//    
procedure ShowHourMinSec (RqImage : TImage;
                          X, Y, Radius,
                          Hour, Min, Sec : integer);
var XE, YE : integer;
    PE     : TPoint;
begin
  //    
  with RqImage.Canvas
  do begin
      Brush.Style := bsClear;
      Pen.Style := psSolid;
      Pen.Mode := pmCopy;
      PE.X := X;
      PE.Y := Y;
      //   (   )
      AngleRadiusToXY (90 - (Hour mod 12) * (360 div 12)
                          - (Min div 12)  * (360 div 60),
                       Radius - (Radius div 3),
                       XE, YE);
      Pen.Color := RGB (100,100,100);
      Pen.Width := 3;
      PenPos := PE;
      LineTo(X + XE, Y - YE);
      //   (   )
      AngleRadiusToXY (90 - Min * (360 div 60),
                       Radius - (Radius div 6),
                       XE, YE);
      Pen.Color := RGB(100,100,100);
      Pen.Width := 2;
      PenPos := PE;
      LineTo(X + XE, Y - YE);
      //    (   )
      AngleRadiusToXY (90 - Sec * (360 div 60), Radius - 2, XE, YE);
      Pen.Color := RGB(0,0,0);
      Pen.Width := 1;
      PenPos := PE;
      LineTo(X + XE, Y - YE);
      //   
      ShowCircle(RqImage,X,Y,4,RGB(50,50,50));
  end;
end;
// ------------------------------------------------------------------------
//       
procedure ShowDigitalDateTime (RqImage    : TImage;
                               RqDateTime : TDateTime);
const DateTimeX = 15;
      DateY     = 15;
      TimeY     = 30;
var   WStr      : string[32];

begin
   with RqImage.Canvas
   do begin
     Brush.Color := RGB(64,64,200);   //     
     Font.Color := RGB(255,255,255);  //     
     //  
     WStr := ' ' + DateToStr(RqDateTime) + ' ';
     TextOut(DateTimeX, DateY, WStr);
     //  
     WStr := ' ' + TimeToStr(RqDateTime) + ' ';
     TextOut(DateTimeX, RqImage.Height - TimeY, WStr);
   end;
end;
// ------------------------------------------------------------------------
//      
procedure  ShowDateTime (RqImage : TImage);
var DateTime : TDateTime;
    Year, Month, Day, Hour, Min, Sec, MSec: Word;
begin
   DateTime := Now;  //    
   DecodeDate(DateTime, Year, Month, Day);
   DecodeTime(DateTime, Hour, Min, Sec, MSec);
   //   
   ShowCircle(RqImage,RqImage.Width  div 2,
              RqImage.Height div 2,
              ((RqImage.Width + RqImage.Height) div 4) - PointDR,
              RqImage.Parent.Brush.Color);
   //       
   ShowDigitalDateTime (RqImage, DateTime);
   //     
   ShowHourMinSec (RqImage,
                   RqImage.Width  div 2,
                   RqImage.Height div 2,
                   ((RqImage.Width + RqImage.Height) div 4) - PointDR,
                   Hour, Min, Sec);
end;
// ------------------------------------------------------------------------
//   
procedure  InitShowDateTime (RqImage : TImage; RqW, RqH : integer);
begin
   RqImage.Width  := RqW;
   RqImage.Height := RqH;
   RqImage.Canvas.CopyMode := cmSrcCopy;
   ClearImage (RqImage);
   //    
   ShowHourDigits (RqImage,
                   RqImage.Width  div 2,
                   RqImage.Height div 2,
                   ((RqImage.Width + RqImage.Height) div 4) - DigitDR);
   //      
   ShowDateTime (RqImage);
end;
// ========================================================================
// ========================================================================

(*
// ========================================================================
//       
// ========================================================================
// ------------------------------------------------------------------------
//   
procedure TForm1.Timer1Timer(Sender: TObject);
begin
   Timer1.Interval := 1000;
   //      
   ShowDateTime (Image1);
end;
// ------------------------------------------------------------------------
//  
procedure TForm1.FormCreate(Sender: TObject);
var MinW, MinH, MaxW, MaxH : integer;
begin
   MinW := 250;
   MinH := 250;
   MaxW := 400;
   MaxH := 350;
   Self.Constraints.MinWidth  := MinW;
   Self.Constraints.MinHeight := MinH;
   Self.Constraints.MaxWidth  := MaxW;
   Self.Constraints.MaxHeight := MaxH;
   Self.Width  := 300;
   Self.Height := 300;
   //   
   InitShowDateTime(Image1, Self.ClientWidth, Self.ClientHeight);
end;
// ------------------------------------------------------------------------
//   
procedure TForm1.FormCanResize(Sender: TObject; var NewWidth,
  NewHeight: Integer; var Resize: Boolean);
begin
 if Resize
 then begin
   //    
   InitShowDateTime(Image1, Self.ClientWidth, Self.ClientHeight);
 end;
end;

*)
// ========================================================================
// ========================================================================

end.
