unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    ButtonRunArr: TButton;
    Memo1: TMemo;
    ComboBoxStr: TComboBox;
    EditForStr: TEdit;
    ButtonRunStr: TButton;
    Bevel1: TBevel;
    LabelStr: TLabel;
    EditForArr: TEdit;
    ComboBoxD1: TComboBox;
    ComboBoxD2: TComboBox;
    ComboBoxArr: TComboBox;
    Bevel2: TBevel;
    EditInt: TEdit;
    EditDbl: TEdit;
    ButtonRunIntDbl: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Bevel3: TBevel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    LabelTitle: TLabel;
    procedure ButtonRunArrClick(Sender: TObject);
    procedure ButtonRunStrClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonRunIntDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}

const ArrMaxInd = 3;
//  
var S1DArr : array [0..ArrMaxInd] of integer;
    D1DArr : array of integer;
//  
var S2DArr : array [0..ArrMaxInd,0..ArrMaxInd] of integer;
    D2DArr : array of array of integer;

//     
function ByteToHexStr (RqByte : byte): string;
const HexCharsArray : array[0..15] of char =
   ('0','1','2','3','4','5','6','7',
    '8','9','A','B','C','D','E','F');
begin
 //      Hex - 
 Result:= HexCharsArray[$0F and RqByte];
 //       
 Result:= HexCharsArray[($F0 and RqByte) shr 4] + Result;
end;

//       
//   RqSize ,    
// RqAddr.
function MemToHexStr (RqAddr : pointer; RqSize : integer): string;
var pt1 : ^byte;    //   
    Ind : integer;  //    
begin
  Result := '';
  if (RqAddr <> nil) and (RqSize > 0)
  then begin
    pt1 := RqAddr;
    try
      for Ind := 0 to RqSize -1 do
      begin
        Result := Result + ByteToHexStr(pt1^);
        //   
        pt1 := Ptr(Integer(pt1) + 1);
      end;
    except
       ShowMessage(' .  .');
    end;
  end;
end;

//     RqSize ,  
//   RqAddr,     .
procedure MemToHexAndCharDump (RqAddr : pointer;
                               RqSize : integer;
                               RqReport : TMemo);
const SLen    = SizeOf(integer);  //      
var   pt1     : ^byte;            //      
      BCount  : integer;          //     
      SCount  : integer;          //      
      WCount  : integer;          //      
      HStr    : string[80];       //   
      CStr    : string[80];       //   
begin

  if (RqAddr <> nil) and (RqSize > 0)
  then begin
    pt1     := RqAddr;
    BCount  := RqSize;
    RqReport.Lines.Add('Addr' + #09#09 + 'Hex' + #09#09 + 'Char');
    try
      repeat //    
          HStr   := Format('%p',[pt1]) + ':' + #09;
          CStr   := '';
          SCount := SLen;
          WCount := SizeOf(integer);
          repeat  //    
            HStr := HStr + ByteToHexStr(pt1^);
            WCount := WCount - 1;
            if WCount <= 0
            then begin
               HStr := HStr + ' ';
               WCount := SizeOf(integer);
            end;
            if pt1^ < $20  //   
            then CStr := CStr + '.'
            else CStr := CStr + Char(pt1^);
            //   
            pt1 := Ptr(Integer(pt1) + 1);
            BCount := BCount - 1;
            SCount := SCount - 1;
          until (SCount <=0);
          RqReport.Lines.Add(HStr + ' ' + #09 + CStr);
      until (BCount <= 0);
    except
       ShowMessage(' .  .');
    end;
  end;
end;


//      
//    .  RqAddrDArray := Addr(NameDArray)
//   ,    .  RqDArrayItemSize
//        .
procedure HexShowDynArray1D (RqAddrDArray     : pointer;
                             RqDArrayItemSize : integer;
                             RqReport : TMemo);
var pp1  : ^pointer;
    pLen : ^integer;
begin
    RqReport.Lines.Add(' ,    : '
                      + Format('%p',[RqAddrDArray]));
    pp1 := RqAddrDArray;
    RqReport.Lines.Add(' ,   :');
    MemToHexAndCharDump (RqAddrDArray, SizeOf(RqAddrDArray), RqReport);
    RqReport.Lines.Add('     : '
                      + Format('%p',[pp1^]));
    //      
    pLen := Ptr(Integer(pp1^) - 4);
    RqReport.Lines.Add(' ,     : '
                      + Format('%p',[pLen]));
    RqReport.Lines.Add('      : '
                      + IntToStr(pLen^));
    RqReport.Lines.Add(' ,   :');
    MemToHexAndCharDump (pLen,
                         SizeOf(pLen^) + pLen^ * RqDArrayItemSize,
                         RqReport);
end;

//      
//    .  RqAddrDArray := Addr(NameDArray)
//   ,    .  RqDArrayItemSize
//        .
procedure HexShowDynArray2D (RqAddrDArray     : pointer;
                             RqDArrayItemSize : integer;
                             RqReport : TMemo);
var ppD1   : ^pointer;
    pLenD1 : ^integer;
    ppD2   : ^pointer;
    pLenD2 : ^integer;
    DCount : integer;
begin
    RqReport.Lines.Add(' ,    : '
                      + Format('%p',[RqAddrDArray]));
    ppD1 := RqAddrDArray;
    RqReport.Lines.Add(' ,   :');
    MemToHexAndCharDump (RqAddrDArray, SizeOf(RqAddrDArray), RqReport);
    RqReport.Lines.Add('     : '
                      + Format('%p',[ppD1^]));
    //      
    pLenD1 := Ptr(Integer(ppD1^) - 4);
    RqReport.Lines.Add(' ,     : '
                      + Format('%p',[pLenD1]));
    RqReport.Lines.Add('      : '
                      + IntToStr(pLenD1^));
    RqReport.Lines.Add(' ,  1-  :');
    RqReport.Lines.Add('(     2- )');
    MemToHexAndCharDump (pLenD1,
                         SizeOf(pLenD1^) + pLenD1^ * SizeOf(Pointer),
                         RqReport);
    RqReport.Lines.Add(' ,   2- :');
    if pLenD1^ > 0 then
    begin
       DCount := pLenD1^;
       ppD2   := ppD1^;
       repeat
         RqReport.Lines.Add('     : '
                           + Format('%p',[ppD2^]));
         pLenD2 := Ptr(Integer(ppD2^) - 4);
         RqReport.Lines.Add('     : '
                           + IntToStr(pLenD2^));
         MemToHexAndCharDump (pLenD2,
                              SizeOf(pLenD2^) + pLenD2^ * RqDArrayItemSize,
                              RqReport);
         //                          
         ppD2 := Ptr(Integer(ppD2) + SizeOf(Pointer));
         DCount := DCount - 1;
       until (DCount <= 0);
    end;                     

end;

//  ComboBox-   
procedure TForm1.FormCreate(Sender: TObject);
//  
var Ind1, Ind2  : integer;
begin
   //  ComboBox-
   ComboBoxD1.Clear;
   ComboBoxD2.Clear;
   //  
   SetLength(D1DArr, ArrMaxInd + 1);
   SetLength(D2DArr, ArrMaxInd + 1);
   for Ind1:=0 to ArrMaxInd
   do begin
     //    
     ComboBoxD1.Items.Add(IntToStr(Ind1));
     ComboBoxD2.Items.Add(IntToStr(Ind1));
     //   
     SetLength(D2DArr[Ind1], ArrMaxInd + 1);
     S1DArr[Ind1] := Ind1;
     D1DArr[Ind1] := Ind1;
     for Ind2:=0 to ArrMaxInd
     do begin
       S2DArr[Ind1,Ind2] := Ind2;
       D2DArr[Ind1,Ind2] := Ind2;
     end;
   end;
   //     
   ComboBoxD1.ItemIndex := 0;
   ComboBoxD2.ItemIndex := 0;
end;

//  
procedure TForm1.ButtonRunArrClick(Sender: TObject);
//  
var Ind1, Ind2  : integer;
begin
    case ComboBoxArr.ItemIndex of
    0 : begin  //   
           // 
           try
              Ind1:= ComboBoxD1.ItemIndex;
              S1DArr[Ind1] := StrToInt(EditForArr.Text);
              EditForArr.Color := clWindow;
           except
              EditForArr.Color := RGB(255,210,210);
              ShowMessage('    Integer.');
           end;
           // 
           Memo1.Clear;
           Memo1.Lines.Add('       1D :');
           Memo1.Lines.Add(' var S1DArr : array [0..'
                           + IntToStr(ArrMaxInd)
                           + '] of integer;');
           Memo1.Lines.Add(' ,   : '
                      + Format('%p',[Addr(S1DArr)]));
           Memo1.Lines.Add('     : '
                      + IntToStr(Length(S1DArr)));
           Memo1.Lines.Add(' ,   : ');
           MemToHexAndCharDump (Addr(S1DArr),
                                Length(S1DArr) * SizeOf(integer),
                                Memo1);
        end;
    1 : begin  //   
           // 
           try
              Ind1:= ComboBoxD1.ItemIndex;
              D1DArr[Ind1] := StrToInt(EditForArr.Text);
           except
              ShowMessage('   .');
           end;
           // 
           Memo1.Clear;
           Memo1.Lines.Add('       1D ');
           Memo1.Lines.Add('    D1DArr : array of integer;');
           HexShowDynArray1D (Addr(D1DArr),
                              SizeOf(integer),
                              Memo1);
        end;
    2 : begin  //   
           // 
           try
              Ind1:= ComboBoxD1.ItemIndex;
              Ind2:= ComboBoxD2.ItemIndex;
              S2DArr[Ind1,Ind2] := StrToInt(EditForArr.Text);
           except
              ShowMessage('   .');
           end;
           // 
           Memo1.Clear;
           Memo1.Lines.Add('       2D :');
           Memo1.Lines.Add(' var S2DArr : array [0..'
                           + IntToStr(ArrMaxInd)
                           + ',0..' + IntToStr(ArrMaxInd)
                           + '] of integer;');
           Memo1.Lines.Add(' ,   : '
                      + Format('%p',[Addr(S2DArr)]));
           Ind1 := Length(S2DArr);
           Ind2 := Length(S2DArr[0]);
           Memo1.Lines.Add('     : '
                          + IntToStr(Ind1 * Ind2));
           Memo1.Lines.Add(' ,   : ');
           MemToHexAndCharDump (Addr(S2DArr),
                                (Ind1 * Ind2) * SizeOf(integer),
                                Memo1);

        end;
    3 : begin
           // 
           try
              Ind1:= ComboBoxD1.ItemIndex;
              Ind2:= ComboBoxD2.ItemIndex;
              D2DArr[Ind1,Ind2] := StrToInt(EditForArr.Text);
           except
              ShowMessage('   .');
           end;
           // 
           Memo1.Clear;
           Memo1.Lines.Add('        2D :');
           Memo1.Lines.Add(' D2DArr : array of array of integer;');
           HexShowDynArray2D (Addr(D2DArr),
                              SizeOf(integer),
                              Memo1);
        end;
    end;
end;

//  
procedure TForm1.ButtonRunStrClick(Sender: TObject);
const StrLen = 31;
//  
var   SStr  : string [StrLen];             //  
      DStr  : string;                      //  
// - 
var   ntStr  : array [0..StrLen] of char;  //  NT-
      ntDStr : PChar;                      //  NT-
//  
var   Ind1  :  integer;
      Ind2  :  integer;
begin
  case ComboBoxStr.ItemIndex of
  0 : begin
        // 
        SStr := EditForStr.Text;
        // 
        Memo1.Clear;
        Memo1.Lines.Add('       :');
        Memo1.Lines.Add('     var SStr : string ['
                             + IntToStr(StrLen) + '];');
        Memo1.Lines.Add(' 1D- CHAR-');
        Memo1.Lines.Add(' ,   : '
                      + Format('%p',[Addr(SStr)]));
        Memo1.Lines.Add(' ,    : '
                      + Format('%p',[Addr(SStr)]));
        Memo1.Lines.Add('   : '
                      + IntToStr(Length(SStr)));
        Memo1.Lines.Add(' ,   :');
        MemToHexAndCharDump (Addr(SStr), SizeOf(SStr), Memo1);
      end;
   1 : begin
         // 
         DStr := EditForStr.Text;
         // 
         Memo1.Clear;
         Memo1.Lines.Add('          ');
         Memo1.Lines.Add('          var DStr : string;');
         Memo1.Lines.Add(' 1D- CHAR-');
         HexShowDynArray1D (Addr(DStr), SizeOf(Char), Memo1);
       end;
  2 : begin
        // 
        //    #0
        FillChar(ntStr, SizeOf(ntStr), 0);
        //    - 
        Ind2 := Length(EditForStr.Text);
        if Ind2 >= StrLen then Ind2 := StrLen - 1;
        for Ind1 := 0 to Ind2 do ntStr[Ind1] := EditForStr.Text[Ind1+1];
        // 
        Memo1.Clear;
        Memo1.Lines.Add(' - :');
        Memo1.Lines.Add('    var ntStr : array [0..'
                       + IntToStr(StrLen)
                       + '] of char;');
        Memo1.Lines.Add(' 1D- CHAR-');
        Memo1.Lines.Add(' ,   : '
                      + Format('%p',[Addr(ntStr)]));
        Memo1.Lines.Add(' ,   :');
        MemToHexAndCharDump (Addr(ntStr), SizeOf(ntStr), Memo1);
      end;
   3 : begin
         // 
         ntDStr := PChar(EditForStr.Text);
         // 
         Memo1.Clear;
         Memo1.Lines.Add('  - ');
         Memo1.Lines.Add('        var ntDStr :  PChar;');
         Memo1.Lines.Add(' 1D- CHAR-');
         HexShowDynArray1D (Addr(ntDStr), SizeOf(Char), Memo1);
       end;
  end; // of case
end;

//  
procedure TForm1.ButtonRunIntDblClick(Sender: TObject);
var Int1 : integer;
    Dbl1 : double;
begin
    try
       Int1 := StrToInt(EditInt.Text);
       Dbl1 := StrToFloat(EditDbl.Text);
       EditInt.Color := clWindow;
       EditDbl.Color := clWindow;
    except
       EditInt.Color := RGB(255,210,210);
       EditDbl.Color := RGB(255,210,210);
       ShowMessage('    Integer  Real.');
    end;
    // 
    Memo1.Clear;
    Memo1.Lines.Add('      :');
    Memo1.Lines.Add('     var Int1 : integer = '
                         + IntToStr(Int1) + ';');
    Memo1.Lines.Add('     var Dbl1 : double = '
                         + FloatToStr(Dbl1) + ';');
    Memo1.Lines.Add(' ,   Int1: '
                   + Format('%p',[Addr(Int1)]));
    Memo1.Lines.Add(' ,   Int1: ');
    MemToHexAndCharDump (Addr(Int1), SizeOf(Int1), Memo1);
    Memo1.Lines.Add(' ,   Dbl1: '
                   + Format('%p',[Addr(Dbl1)]));
    Memo1.Lines.Add(' ,   Dbl1: ');
    MemToHexAndCharDump (Addr(Dbl1), SizeOf(Dbl1), Memo1);
end;

end.
