unit Unit1;

//       
//   .    
//     New  Dispose. 
//       
//     (TQElementRec).   
//       TTstObject.

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

// ========================================================
//   
// Queue     
// Head      
// Tail      
// Element   
// Current   
// Next      
// Previous  

type TQueueRec = record
//    (ver. 1.0)
 QEKey   : longword;  //    (Inc only)
 QECount : longword;  //    
 ptHead  : pointer;   //   
 ptTail  : pointer;   //   
 ptCurr  : pointer;   //   
end;

type TQElementRec = record
//    (ver. 1.0)
 ptNext : pointer;   //    
 ptPrev : pointer;   //    
 ENum   : longword;  //   
 ptObj  : pointer;   //   
end;

type
  ptQueue_Type = ^TQueueRec;
  ptQElement_Type = ^TQElementRec;
// ========================================================

type TTstObject = record
//    
 ptQEtop  : pointer;     //    
 CrDTime  : TDateTime;   //     
 TitStr   : string[80];  //   
 DatStr   : string[80];  //  
 ComStr   : string[80];  //  
end;

type
  ptTstObject_Type = ^TTstObject;

// ========================================================
//  
type
  TForm1 = class(TForm)
    Bevel1: TBevel;
    stxtQECount: TStaticText;
    stxtQEKey: TStaticText;
    Bevel2: TBevel;
    bttToHead: TButton;
    bttPrev: TButton;
    bttNext: TButton;
    bttToTail: TButton;
    bttAdd: TButton;
    bttDel: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    stxtQENum: TStaticText;
    Label5: TLabel;
    cboxAdd: TComboBox;
    cboxDel: TComboBox;
    Bevel3: TBevel;
    stxtHead: TStaticText;
    stxtCurrent: TStaticText;
    stxtTail: TStaticText;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    edTitStr: TEdit;
    edDatStr: TEdit;
    edComStr: TEdit;
    stxtDTime: TStaticText;
    Bevel4: TBevel;
    bttAddObj: TButton;
    bttDelObj: TButton;
    shpLink: TShape;
    bttUpDateObj: TButton;
    Label10: TLabel;
    Label11: TLabel;
    procedure bttAddClick(Sender: TObject);
    procedure bttNextClick(Sender: TObject);
    procedure bttPrevClick(Sender: TObject);
    procedure bttDelClick(Sender: TObject);
    procedure bttToHeadClick(Sender: TObject);
    procedure bttToTailClick(Sender: TObject);
    procedure bttAddObjClick(Sender: TObject);
    procedure bttDelObjClick(Sender: TObject);
    procedure bttUpDateObjClick(Sender: TObject);
  private
    { Private declarations }
    function  GetQueue() : pointer;
    procedure ShowQueueStat(ptQueue : ptQueue_Type);
    // =================    =============
    procedure InsertQElement (ptQueue : ptQueue_Type; Cmd : char; ptQEnew : ptQElement_Type);
    procedure AddNewQElement(ptQueue : ptQueue_Type; Cmd : char);
    function  CutQElement( ptQueue : ptQueue_Type; Cmd : char) : pointer;
    procedure DelQElement(ptQueue : ptQueue_Type; Cmd : char);
    function  QueueNavigate(ptQueue : ptQueue_Type; Cmd : char): pointer;
    procedure ShowCurrentQElement(ptQueue : ptQueue_Type);
    function  GetCurrentPtQE(ptQueue : ptQueue_Type) : pointer;
    function  InsertPtObj(ptQueue : ptQueue_Type; ptObj : pointer) : boolean;
    function  GetPtObj(ptQueue : ptQueue_Type) : pointer;
    function  CutPtObj(ptQueue : ptQueue_Type) : pointer;
    // ==================   Attach  ========
    procedure AddNewTstObj(ptQueue : ptQueue_Type);
    procedure DelTstObj(ptQueue : ptQueue_Type);
    procedure UpDateTstObj(ptQueue : ptQueue_Type);
    procedure ShowTstObj(ptQueue : ptQueue_Type);
    // ==================  ==========================
    procedure ShowAll(ptQueue : ptQueue_Type);
  public
    { Public declarations }
  end;
// ========================================================
var
  Form1 : TForm1;
// ========================================================
implementation
{$R *.dfm}

// ========================================================
//     
// ========================================================
var
    QueueRec    : TQueueRec;
    ptTQueueRec : ptQueue_Type;

function TForm1.GetQueue() : pointer;
begin
//    
   ptTQueueRec := Addr(QueueRec);
   GetQueue := ptTQueueRec;
end;

procedure TForm1.ShowQueueStat(ptQueue : ptQueue_Type);
var ptQE  : ptQElement_Type;
begin
  if ptQueue <> nil
  then begin
    stxtQECount.Caption := IntToStr(ptQueue^.QECount);
    stxtQEKey.Caption := IntToStr(ptQueue^.QEKey);

    ptQE := ptQueue^.ptHead;
    if ptQE <> nil
    then stxtHead.Caption := IntToStr(ptQE^.ENum)
    else stxtHead.Caption :='';

    ptQE := ptQueue^.ptCurr;
    if ptQE <> nil
    then stxtCurrent.Caption := IntToStr(ptQE^.ENum)
    else stxtCurrent.Caption :='';

    ptQE := ptQueue^.ptTail;
    if ptQE <> nil
    then stxtTail.Caption := IntToStr(ptQE^.ENum)
    else stxtTail.Caption :='';
  end;
end;

// ==============================
//    
// ==============================

//    
procedure TForm1.InsertQElement
  ( ptQueue : ptQueue_Type;    //    
    Cmd     : char;            //  'H' -   head, 'T'  tail 
    ptQEnew : ptQElement_Type  //     
  );
var ptQE    : ptQElement_Type;
begin
 // ,    
 if (ptQueue^.ptHead = nil) and (ptQueue^.ptTail = nil)
 then begin
   // INSERT   
   ptQueue^.ptHead := ptQEnew;
   ptQueue^.ptTail := ptQEnew;
 end
 else begin
   // INSERT    
   case UpCase(Cmd) of
   'H': begin
       //      
       ptQE := ptQueue^.ptHead;    //     
       ptQE^.ptPrev := ptQEnew;    //      
       ptQEnew^.ptNext := ptQE;    //      
       ptQueue^.ptHead := ptQEnew; //      
       end;
   'T': begin
       //      
       ptQE := ptQueue^.ptTail;    //     
       ptQE^.ptNext := ptQEnew;    //      
       ptQEnew^.ptPrev := ptQE;    //      
       ptQueue^.ptTail := ptQEnew; //      
       end;
   end; // case
 end;
 Inc(ptQueue^.QEKey);              // +1    
 Inc(ptQueue^.QECount);            // +1     
 ptQEnew^.ENum := ptQueue^.QEKey;  //    
 ptQueue^.ptCurr := ptQEnew;       //  INSERT   
end;

procedure TForm1.AddNewQElement(ptQueue : ptQueue_Type; Cmd : char);
var   ptQEnew : ptQElement_Type;
begin
//    
   try
     New(ptQEnew); //       
     Fillchar(ptQEnew^, SizeOF(ptQEnew^),#0);  //  
     InsertQElement ( ptQueue,Cmd,ptQEnew);    //   
    except
      ShowMessage('      ');
   end;
   ShowQueueStat(ptQueue);
end;

//    
function TForm1.CutQElement
  ( ptQueue  : ptQueue_Type;  //    
    Cmd      : char           //  'H' -   head, 'T'  tail 
  ) : pointer;                //     
var
    ptQEcut,
    ptQE     : ptQElement_Type;
begin
 CutQElement := nil;          //  
 // ,    
 if (ptQueue^.ptHead <> nil) and (ptQueue^.ptTail <> nil)
 then begin
   //   
   case UpCase(Cmd) of
   'H': begin
      //     
      ptQEcut := ptQueue^.ptHead; //      
      ptQE := ptQEcut^.ptNext;    //     nil
      if (ptQE = nil)             // ptQEcut    ?
      then ptQueue^.ptTail := nil
      else ptQE^.ptPrev := nil;
       ptQueue^.ptHead := ptQE;    //    
   end;
   'T': begin
      //     
      ptQEcut := ptQueue^.ptTail; //      
      ptQE := ptQEcut^.ptPrev;    //     nil
      if (ptQE = nil)             // ptQEcut    ?
      then ptQueue^.ptHead := nil
      else ptQE^.ptNext := nil;
      ptQueue^.ptTail := ptQE;    //    
   end;
   end; // case
   ptQueue^.ptCurr := ptQE;
   if (ptQueue^.ptTail = nil) or (ptQueue^.ptHead = nil)
   then Fillchar(ptQueue^, SizeOF(ptQueue^),#0)  //   
   else Dec(ptQueue^.QECount);    //     
   CutQElement := ptQEcut;        //    
 end;
end;

procedure TForm1.DelQElement
   (ptQueue : ptQueue_Type;       //    
    Cmd     : char                //  'H' -   head, 'T'  tail 
   );
//    
var  ptQEdel : ptQElement_Type;
begin
  case UpCase(Cmd) of
  'H': ptQEdel:=ptQueue^.ptHead;
  'T': ptQEdel:=ptQueue^.ptTail;
  else ptQEdel:= nil
  end;
  if (ptQEdel <> nil)
  then begin
    if (ptQEdel^.ptObj = nil)
    then begin
      //     
      ptQEdel := CutQElement( ptQueue,Cmd);
      if (ptQEdel <> nil)
      then begin
        try
          Fillchar(ptQEdel^, SizeOF(ptQEdel^),#0);  // 
          Dispose(ptQEdel);    //   
        except
          ShowMessage('     ');
        end;
      end;
    end
    else ShowMessage('    .   .');
  end;
end;

function TForm1.QueueNavigate
   (ptQueue : ptQueue_Type;
    Cmd : char
   ): pointer;
var ptQE : ptQElement_Type;
begin
  QueueNavigate := nil;
  ptQE := nil;
  if (ptQueue <> nil)
  then begin
    case UpCase(Cmd) of
    'H': ptQE := ptQueue^.ptHead;
    'N': begin
           ptQE := ptQueue^.ptCurr;
           if ptQE <> nil
           then ptQE := ptQE^.ptNext
           else ptQE := nil;
         end;
    'P': begin
           ptQE := ptQueue^.ptCurr;
           if ptQE <> nil
           then ptQE := ptQE^.ptPrev
           else ptQE := nil;
         end;
    'T': ptQE := ptQueue^.ptTail;
    end; // of case
    if ptQE <> nil
    then begin
      ptQueue^.ptCurr:=ptQE;
      QueueNavigate :=ptQE;
    end;
  end; // of if
end;

procedure TForm1.ShowCurrentQElement(ptQueue : ptQueue_Type);
var ptQE : ptQElement_Type;
begin
  if (ptQueue <> nil)
  then begin
    ptQE := ptQueue^.ptCurr;
    if (ptQE <> nil)
    then stxtQENum.Caption := IntToStr(ptQE^.ENum)
    else stxtQENum.Caption := '';
  end
  else stxtQENum.Caption := '';
end;

function TForm1.GetCurrentPtQE(ptQueue : ptQueue_Type) : pointer;
begin
  GetCurrentPtQE := nil;
  if ptQueue <> nil
  then GetCurrentPtQE := ptQueue^.ptCurr;
end;

// ==================================
//    
// ==================================

//       
function TForm1.InsertPtObj(ptQueue : ptQueue_Type; ptObj : pointer) : boolean;
var ptQE : ptQElement_Type;
begin
  InsertPtObj := False;     //    
  ptQE := GetCurrentPtQE(ptQueue);
  if ptQE <> nil
  then begin
    if ptQE^.ptObj = nil
    then begin
      ptQE^.ptObj := ptObj; //     
      InsertPtObj := True;  //   
    end
    else ShowMessage('Queue- .     ');
  end;
end;

//       
function TForm1.GetPtObj(ptQueue : ptQueue_Type) : pointer;
var ptQE : ptQElement_Type;
begin
  GetPtObj := nil;
  if ptQueue <> nil
  then begin
     ptQE := ptQueue^.ptCurr;
     if ptQE <> nil then GetPtObj := ptQE^.ptObj;
  end;
end;

//       
function TForm1.CutPtObj(ptQueue : ptQueue_Type) : pointer;
var ptQE : ptQElement_Type;
begin
  CutPtObj := nil;              //    
  ptQE := GetCurrentPtQE(ptQueue);
  if ptQE <> nil
  then begin
    if ptQE^.ptObj <> nil
    then begin
      CutPtObj := ptQE^.ptObj;
      ptQE^.ptObj := nil;       //  
    end;
  end;
end;

// ========================================================
//       
// ========================================================

procedure TForm1.AddNewTstObj(ptQueue : ptQueue_Type);
var  ptTO : ptTstObject_Type;
begin
  //        
  if GetCurrentPtQE(ptQueue) <> nil
  then begin
    if GetPtObj(ptQueue) = nil
    then begin
      try
        New(ptTO); //     
        Fillchar(ptTO^, SizeOF(ptTO^),#0);  //   
        ptTO^.CrDTime := Now();             //    .
        InsertPtObj(ptQueue, ptTO);         //     
      except
        ShowMessage('      ');
      end;
    end
    else ShowMessage('   .  ');
  end
  else ShowMessage('  .  ');
end;

procedure TForm1.DelTstObj(ptQueue : ptQueue_Type);
var  ptTO : ptTstObject_Type;
begin
  //        
  ptTO := CutPtObj(ptQueue);
  if ptTO <> nil
  then begin
    try
      Fillchar(ptTO^, SizeOF(ptTO^),#0);  // 
      Dispose(ptTO);                      //   
    except
      ShowMessage('     ');
    end;
  end;
end;

procedure TForm1.ShowTstObj(ptQueue : ptQueue_Type);
var ptTO : ptTstObject_Type;
begin
 stxtDTime.Caption := '';
 edTitStr.Text := '';
 edDatStr.Text := '';
 edComStr.Text := '';
 ptTO := GetPtObj(ptQueue);
 if ptTO <> nil
 then begin
    shpLink.Visible := True;
    stxtDTime.Caption := DateTimeToStr(ptTO^.CrDTime);
    edTitStr.Text := ptTO^.TitStr;
    edTitStr.Enabled := True;
    edDatStr.Text := ptTO^.DatStr;
    edDatStr.Enabled := True;
    edComStr.Text := ptTO^.ComStr;
    edComStr.Enabled := True;
 end
 else begin
    shpLink.Visible := False;
    stxtDTime.Caption := '';
    edTitStr.Text := '';
    edTitStr.Enabled := False;
    edDatStr.Text := '';
    edDatStr.Enabled := False;
    edComStr.Text := '';
    edComStr.Enabled := False;
 end;
end;

procedure TForm1.UpDateTstObj(ptQueue : ptQueue_Type);
var ptTO : ptTstObject_Type;
begin
 ptTO := GetPtObj(ptQueue);
 if ptTO <> nil
 then begin
    stxtDTime.Caption := DateTimeToStr(ptTO^.CrDTime);
    ptTO^.TitStr := edTitStr.Text;
    ptTO^.DatStr := edDatStr.Text;
    ptTO^.ComStr := edComStr.Text;
 end;
end;

// ========================================================
//  
// ========================================================

procedure TForm1.ShowAll(ptQueue : ptQueue_Type);
begin
 ShowQueueStat(ptQueue);
 ShowCurrentQElement(ptQueue);
 ShowTstObj(ptQueue);
end;

// ========================================================
procedure TForm1.bttAddClick(Sender: TObject);
begin
 AddNewQElement(GetQueue(), cboxAdd.Text[1]);
 ShowAll(GetQueue());
end;

procedure TForm1.bttDelClick(Sender: TObject);
begin
 DelQElement(GetQueue(), cboxDel.Text[1]);
 ShowAll(GetQueue());
end;

procedure TForm1.bttNextClick(Sender: TObject);
begin
 QueueNavigate (GetQueue(),'N');
 ShowAll(GetQueue());
end;

procedure TForm1.bttPrevClick(Sender: TObject);
begin
 QueueNavigate (GetQueue(),'P');
 ShowAll(GetQueue());
end;

procedure TForm1.bttToHeadClick(Sender: TObject);
begin
 QueueNavigate (GetQueue(),'H');
 ShowAll(GetQueue());
end;

procedure TForm1.bttToTailClick(Sender: TObject);
begin
 QueueNavigate (GetQueue(),'T');
 ShowAll(GetQueue());
end;

procedure TForm1.bttAddObjClick(Sender: TObject);
begin
 AddNewTstObj(GetQueue());
 ShowTstObj(GetQueue());
end;

procedure TForm1.bttDelObjClick(Sender: TObject);
begin
 DelTstObj(GetQueue());
 ShowTstObj(GetQueue());
end;

procedure TForm1.bttUpDateObjClick(Sender: TObject);
begin
 UpDateTstObj(GetQueue());
 ShowTstObj(GetQueue());
end;

end.
