unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}

type TDayOfWeek = (MON=1,TUE,WED,THU,FRI,SAT,SUN);

function DayExist (RqDay : TDayOfWeek) : boolean;
var CurDay : TDayOfWeek;
begin
  Result := False;
  CurDay := Low(TDayOfWeek);
  repeat
    if CurDay = RqDay
    then Result := True
    else CurDay := Succ(CurDay);
  until (Result = True) or (CurDay > High(TDayOfWeek));
end;

function DayName (RqDay : TDayOfWeek) : string;
begin
  Result := ' ';
  case RqDay of
  MON : Result := '';
  TUE : Result := '';
  WED : Result := '';
  THU : Result := '';
  FRI : Result := '';
  SAT : Result := '';
  SUN : Result := '';
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var Ind   : integer;
    RqDay : TDayOfWeek;
begin
  if TryStrToInt(Edit1.Text, Ind)
  then begin
     RqDay :=  TDayOfWeek(Ind);
     if DayExist (RqDay)
     then  Edit2.Text := 'Yes : ' + DayName (RqDay)
     else  Edit2.Text := 'No : '+ DayName (RqDay);
  end
  else Edit2.Text := '     ';
end;

end.
